/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.cli;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.fortiss.af3.project.AF3ProjectActivator;
import org.fortiss.af3.project.utils.FileUtils;
import org.fortiss.af3.project.utils.ProjectUtils;
import org.fortiss.tooling.kernel.extension.ICommandLineSwitchHandler;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.service.listener.IPersistencyServiceListener;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class AF3ProjectImportHandler
implements ICommandLineSwitchHandler {
    private boolean allModelsLoaded = false;

    public boolean hasAdditionalArgument() {
        return true;
    }

    public void handleCLISwitch(String argument) {
        try {
            this.tryImportProjects(argument);
            while (!this.allModelsLoaded) {
                Thread.sleep(500L);
            }
        }
        catch (IOException | InterruptedException e) {
            String impErr = "Could not import one or more of the given AF3 projects.";
            LoggingUtils.error((Plugin)AF3ProjectActivator.getDefault(), (String)impErr, (Throwable)e);
            System.out.println(impErr + "\n\n" + e.getMessage());
        }
    }

    private static Collection<File> getFileList(String importRegExp) {
        File potentialDirectory = new File(importRegExp);
        if (potentialDirectory.isDirectory()) {
            WildcardFileFilter suffixFilter = new WildcardFileFilter(".af3_23");
            return Arrays.asList(potentialDirectory.listFiles((FileFilter)suffixFilter));
        }
        int fileSubStrPos = StringUtils.lastIndexOf((CharSequence)importRegExp, (CharSequence)File.separator);
        String fileStr = StringUtils.substring((String)importRegExp, (int)(fileSubStrPos + File.separator.length()));
        String dirStr = StringUtils.substring((String)importRegExp, (int)0, (int)fileSubStrPos);
        File importDir = new File(dirStr);
        WildcardFileFilter fileFilter = new WildcardFileFilter(Arrays.asList(fileStr, ".af3_23"));
        return Arrays.asList(importDir.listFiles((FileFilter)fileFilter));
    }

    private static Collection<String> getSameProjectNames(Collection<File> importFiles) {
        ArrayList<String> existingProjects = new ArrayList<String>();
        for (File file : importFiles) {
            URI targetPath = FileUtils.getDefaultGeneralProjectURI().appendSegment(file.getName());
            File importTargetFile = new File(targetPath.toFileString());
            if (!importTargetFile.exists()) continue;
            existingProjects.add(importTargetFile.getName());
        }
        return existingProjects;
    }

    private void tryImportProjects(String locationRegexp) throws IOException {
        Collection<File> filesToImport = AF3ProjectImportHandler.getFileList(locationRegexp);
        Collection<String> alreadyExistingProjects = AF3ProjectImportHandler.getSameProjectNames(filesToImport);
        if (!alreadyExistingProjects.isEmpty()) {
            Object errMsg = "The import failed because some equivalently named projects already exist in the workspace. The following duplicates were detected:\n";
            errMsg = (String)errMsg + alreadyExistingProjects.stream().collect(Collectors.joining("\n"));
            errMsg = (String)errMsg + "\nYou can either pass a new workspace location with the switch \"-data <path-to-ws>\" or clean the existing workspace.";
            throw new IOException((String)errMsg);
        }
        Collection prjNames = filesToImport.stream().map(f -> f.getName()).collect(Collectors.toList());
        IPersistencyService.getInstance().addTopLevelElementListener(this.createModelAddedListener(prjNames));
        for (File fileToImport : filesToImport) {
            URI sourceFileURI = URI.createFileURI((String)fileToImport.toString());
            URI targetFileURI = FileUtils.getDefaultGeneralProjectURI().appendSegment(fileToImport.getName());
            ProjectUtils.importFileProject(sourceFileURI, targetFileURI);
        }
    }

    private IPersistencyServiceListener createModelAddedListener(final Collection<String> prjNames) {
        return new IPersistencyServiceListener(){

            public void topLevelElementRemoved(ITopLevelElement element) {
            }

            public void topLevelElementLoaded(ITopLevelElement element) {
            }

            public void topLevelElementContentChanged(ITopLevelElement element) {
            }

            public void topLevelElementAdded(ITopLevelElement element) {
                prjNames.remove(element.getSaveableName());
                if (prjNames.isEmpty()) {
                    IPersistencyService.getInstance().removeTopLevelElementListener((IPersistencyServiceListener)this);
                    AF3ProjectImportHandler.this.allModelsLoaded = true;
                }
            }
        };
    }
}

