/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.extension.base;

import org.fortiss.af3.project.extension.IExecutionTarget;
import org.fortiss.af3.project.extension.data.Executable;
import org.fortiss.af3.project.extension.exception.ExecutionFailedException;

public abstract class ExecutionTargetBase
implements IExecutionTarget {
    @Override
    public final void execute(Executable executable) throws ExecutionFailedException {
        if (executable.getTarget() != this) {
            throw new ExecutionFailedException(this, executable, "Provided executable does not have the correct execution target.");
        }
        if (!this.getExecutableClass().isInstance(executable.getExecutableObject())) {
            throw new ExecutionFailedException(this, executable, "Provided executable does not have the correct executable object.");
        }
        this.doExecute(executable);
    }

    @Override
    public boolean useModelSpecificationInPreparation() {
        return true;
    }

    protected abstract void doExecute(Executable var1);
}

