/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.internal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.project.extension.IExecutionTarget;
import org.fortiss.af3.project.extension.data.Executable;
import org.fortiss.af3.project.extension.data.ExecutionConfigTransformationContext;
import org.fortiss.af3.project.extension.exception.ExecutablePreparationFailedException;
import org.fortiss.af3.project.model.execution.ExecutionConfiguration;
import org.fortiss.af3.project.services.IExecutionService;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.data.TransformationProviderChain;
import org.fortiss.tooling.kernel.extension.exception.ChainTransformationFailedException;
import org.fortiss.tooling.kernel.model.IIdLabeledReference;
import org.fortiss.tooling.kernel.service.ITransformationService;
import org.fortiss.tooling.kernel.utils.ExtensionPointUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.TransformationUtils;
import org.osgi.framework.Bundle;

public class ExecutionService
implements IExecutionService {
    private static final String EXTENSION_POINT_NAME = "org.fortiss.af3.project.executionTarget";
    private static final String CONFIGURATION_ELEMENT_NAME = "executionTarget";
    private final List<IExecutionTarget> executionTargetList = new ArrayList<IExecutionTarget>();

    public ExecutionService() {
        this.setupExecutionTargets();
    }

    @Override
    public UnmodifiableList<IExecutionTarget> getExecutionTargets() {
        return CollectionUtils.asUnmodifiable(this.executionTargetList);
    }

    @Override
    public UnmodifiableList<IExecutionTarget> getExecutionTargets(ExecutionConfiguration config) {
        LinkedList<IExecutionTarget> result = new LinkedList<IExecutionTarget>();
        for (IExecutionTarget target : this.executionTargetList) {
            Class<?> executableClass = target.getExecutableClass();
            EObject source = KernelModelElementUtils.findReferencedElement((IIdLabeledReference)config);
            if (source == null || executableClass == null || this.findTransformationChain(source, executableClass, config).isEmpty()) continue;
            result.add(target);
        }
        return CollectionUtils.asUnmodifiable(result);
    }

    @Override
    public Executable prepareExecutable(ExecutionConfiguration config, IExecutionTarget target) throws ExecutablePreparationFailedException {
        EObject source = KernelModelElementUtils.findReferencedElement((IIdLabeledReference)config);
        if (source == null) {
            throw new ExecutablePreparationFailedException(target, source, "Source element with ID " + config.getIdReference() + " does not exist.");
        }
        return this.prepareExecutableInternal(source, target, config);
    }

    @Override
    public Executable prepareExecutable(EObject sourceElement, IExecutionTarget target) throws ExecutablePreparationFailedException {
        return this.prepareExecutableInternal(sourceElement, target, null);
    }

    private Executable prepareExecutableInternal(EObject sourceElement, IExecutionTarget target, ExecutionConfiguration config) throws ExecutablePreparationFailedException {
        ExecutionConfigTransformationContext context = null;
        if (config != null) {
            context = new ExecutionConfigTransformationContext(config);
        }
        if (target.useModelSpecificationInPreparation() && sourceElement instanceof IModelElement) {
            for (IModelElementSpecification spec : ((IModelElement)sourceElement).getSpecifications()) {
                Object executableObject = TransformationUtils.createTransformedObjectWithoutExceptionFor((EObject)spec, target.getExecutableClass(), (ITransformationContext)context);
                if (executableObject == null) continue;
                return new Executable(sourceElement, target, config, executableObject);
            }
        }
        try {
            Object executableObject = TransformationUtils.createTransformedObjectFor((EObject)sourceElement, target.getExecutableClass(), (ITransformationContext)context);
            return new Executable(sourceElement, target, config, executableObject);
        }
        catch (ChainTransformationFailedException ctfe) {
            throw new ExecutablePreparationFailedException(target, sourceElement, "Source element " + sourceElement.toString() + " could not be transformed into " + target.getExecutableClass().getName(), ctfe);
        }
    }

    private void setupExecutionTargets() {
        for (IConfigurationElement ce : ExtensionPointUtils.getConfigurationElements((String)EXTENSION_POINT_NAME, (String)CONFIGURATION_ELEMENT_NAME)) {
            Bundle bundle = ExtensionPointUtils.getBundle((IConfigurationElement)ce);
            try {
                Class handlerClass = ExtensionPointUtils.loadClass((String)ce.getAttribute("target"), (Bundle)bundle);
                IExecutionTarget target = (IExecutionTarget)handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.executionTargetList.add(target);
            }
            catch (Exception ex) {
                LoggingUtils.error((Plugin)ToolingKernelActivator.getDefault(), (String)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    List<TransformationProviderChain> findTransformationChain(EObject source, Class<?> executableClass, ExecutionConfiguration config) {
        return ITransformationService.getInstance().getTransformationProviderChain(source.getClass(), executableClass, (ITransformationContext)new ExecutionConfigTransformationContext(config));
    }

    @Override
    public <T extends IExecutionTarget> T getSpecificExecutionTarget(Class<T> targetClass) {
        for (IExecutionTarget target : this.executionTargetList) {
            if (!targetClass.isInstance(target)) continue;
            return (T)target;
        }
        return null;
    }
}

