/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.typesystem;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.project.AF3ProjectActivator;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.typesystem.IEvaluationContext;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class DefaultEvaluationContext
implements IEvaluationContext {
    private Map<VarBase, Term<? extends ITerm>> variableValues = new HashMap<VarBase, Term<? extends ITerm>>();
    private final EObject modelContext;

    public DefaultEvaluationContext(EObject modelContext) {
        this.modelContext = modelContext;
    }

    @Override
    public EObject getModelContext() {
        return this.modelContext;
    }

    @Override
    public Term<? extends ITerm> getValue(VarBase variable) {
        return this.variableValues.get(variable);
    }

    @Override
    public void setValue(VarBase variable, Term<? extends ITerm> value) {
        if (value == null) {
            LoggingUtils.warning((Plugin)AF3ProjectActivator.getDefault(), (String)("variable " + variable.getIdentifier() + " is set to null!"));
        }
        this.variableValues.put(variable, value);
    }

    @Override
    public Term<? extends ITerm> remove(VarBase variable) {
        return this.variableValues.remove(variable);
    }

    @Override
    public IEvaluationContext spawnContext() {
        return new DefaultEvaluationContext(this.modelContext);
    }

    @Override
    public IEvaluationContext cloneContext() {
        DefaultEvaluationContext context = new DefaultEvaluationContext(this.modelContext);
        for (VarBase var : this.variableValues.keySet()) {
            context.setValue(var, this.variableValues.get(var));
        }
        return context;
    }

    @Override
    public void clear() {
        this.variableValues.clear();
    }
}

