/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.typesystem.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.project.model.configuration.TypeSystemConfiguration;
import org.fortiss.af3.project.model.typesystem.ITypeSystem;
import org.fortiss.af3.project.services.ITypeSystemService;
import org.fortiss.af3.project.typesystem.IEvaluationContext;
import org.fortiss.af3.project.typesystem.ITermEvaluator;
import org.fortiss.af3.project.typesystem.ITypeChecker;
import org.fortiss.af3.project.typesystem.ITypeSystemCompiler;
import org.fortiss.af3.project.typesystem.ITypeSystemHandler;
import org.fortiss.af3.project.utils.ProjectUtils;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.base.EObjectAwareServiceBase;

public final class TypeSystemService
extends EObjectAwareServiceBase<ITypeSystemHandler<ITypeSystem>>
implements ITypeSystemService {
    private static final String EXTENSION_POINT_NAME = "org.fortiss.af3.project.typesystem";
    private static final String CONFIGURATION_ELEMENT_NAME = "typesystem";
    private static final String HANDLER_CLASS_ATTRIBUTE_NAME = "handler";

    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService((IIntrospectiveKernelService)this);
    }

    public String getIntrospectionDescription() {
        return "The type system service was intended to make AF3 more versatile by allowing different expression languages and typesystems to plugin in vie the plugin mechanism. However, this feature was never fully implemented.";
    }

    public String getIntrospectionLabel() {
        return "Typesystem Service";
    }

    @Override
    public ITypeSystemHandler<? extends ITypeSystem> getHandler(EObject element) {
        TypeSystemConfiguration conf = ProjectUtils.getProjectConfigurationElement(element, TypeSystemConfiguration.class);
        if (conf != null) {
            ITypeSystem typeSystem = conf.getTypesystem();
            List handlerList = this.getRegisteredHandlers(typeSystem.getClass());
            if (handlerList == null || handlerList.isEmpty()) {
                return null;
            }
            return (ITypeSystemHandler)handlerList.get(0);
        }
        return null;
    }

    @Override
    public List<ITypeSystemHandler<? extends ITypeSystem>> getAllRegisteredHandlers() {
        ArrayList<ITypeSystemHandler<? extends ITypeSystem>> result = new ArrayList<ITypeSystemHandler<? extends ITypeSystem>>();
        for (Class clazz : this.handlerMap.keySet()) {
            result.add((ITypeSystemHandler)((List)this.handlerMap.get(clazz)).get(0));
        }
        return result;
    }

    @Override
    public IEvaluationContext createEvaluationContext(EObject element) {
        return this.getHandler(element).createEvaluationContext(element);
    }

    @Override
    public ITypeChecker getTypeChecker(EObject element) {
        return this.getHandler(element).getTypeChecker();
    }

    @Override
    public ITypeSystemCompiler getTypeSystemCompiler(EObject element) {
        return this.getHandler(element).getTypeSystemCompiler();
    }

    @Override
    public ITermEvaluator getTermEvaluator(EObject element) {
        return this.getHandler(element).getTermEvaluator();
    }

    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    protected String getConfigurationElementName() {
        return CONFIGURATION_ELEMENT_NAME;
    }

    protected String getHandlerClassAttribute() {
        return HANDLER_CLASS_ATTRIBUTE_NAME;
    }

    protected boolean requiresUniqueHandler() {
        return true;
    }
}

