/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.utils;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.kernel.model.IExternalDocumentReference;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ExternalFileUtils {
    public static void copyExternalReferences(FileProject fileProject, URI source, URI target) {
        ExternalFileUtils.doCopyExternalDocuments(fileProject, source, target);
    }

    public static void doCopyExternalDocuments(FileProject fileProject, URI source, URI target) {
        EList externalDocuments = EcoreUtils.getChildrenWithType((EObject)fileProject, IExternalDocumentReference.class);
        for (IExternalDocumentReference ref : externalDocuments) {
            File sourcePath = ExternalFileUtils.computeSourcePath(source);
            File destinationPath = ExternalFileUtils.computeDestinationPath(target);
            String uri = FilenameUtils.separatorsToSystem((String)ref.getUri());
            File sourceFile = new File(sourcePath, uri);
            if (!sourceFile.exists()) continue;
            try {
                FileSystemUtils.copyFile((File)sourceFile, (File)new File(destinationPath, uri));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static File computeDestinationPath(URI targetFileURI) {
        return new File(targetFileURI.path()).getParentFile().getAbsoluteFile();
    }

    private static File computeSourcePath(URI sourceFileURI) {
        File sourcePath;
        if (sourceFileURI.isPlatformResource()) {
            IPath workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            sourcePath = new File(workspace.toFile(), sourceFileURI.toPlatformString(false)).getParentFile();
        } else {
            sourcePath = new File(sourceFileURI.path()).getParentFile();
        }
        return sourcePath;
    }
}

