/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.fortiss.af3.project.AF3ProjectActivator;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class FileUtils {
    public static final String AF3_PROJECT_DIRECTORY_NAME = "AF3-Project-Directory";
    public static final IWorkspaceRoot WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot();
    public static final File PROJECT_DIR = new File(String.valueOf(WORKSPACE_ROOT.getLocation()) + File.separator + "AF3-Project-Directory");

    public static String loadTextFileFromPlugin(URI uri) {
        try {
            URL url = new URL(uri.toString());
            InputStream inputStream = url.openConnection().getInputStream();
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                StringBuffer buffer = new StringBuffer();
                String line = in.readLine();
                while (line != null) {
                    buffer.append(line).append('\n');
                    line = in.readLine();
                }
                return buffer.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LoggingUtils.error((Plugin)AF3ProjectActivator.getDefault(), (String)("Error during loading file: " + String.valueOf(uri) + ", e=" + e.toString()), (Throwable)e);
            return "";
        }
    }

    public static IProject getAF3EclipseProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(AF3_PROJECT_DIRECTORY_NAME);
    }

    public static boolean generalProjectExists() {
        return PROJECT_DIR.isDirectory();
    }

    public static String getDefaultGeneralProjectName() {
        return AF3_PROJECT_DIRECTORY_NAME;
    }

    public static String getDefaultGeneralProjectPath() {
        return PROJECT_DIR.toString();
    }

    public static URI getDefaultGeneralProjectURI() {
        return URI.createFileURI((String)FileUtils.getDefaultGeneralProjectPath());
    }
}

