/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.utils;

import org.fortiss.af3.project.AF3ProjectActivator;
import org.fortiss.af3.project.model.AF3ProjectFactory;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.model.ProjectConfiguration;
import org.fortiss.af3.project.model.configuration.ConfigurationFactory;
import org.fortiss.af3.project.model.configuration.TypeSystemConfiguration;
import org.fortiss.af3.project.model.execution.ExecutionConfiguration;
import org.fortiss.af3.project.model.execution.ExecutionConfigurationStore;
import org.fortiss.af3.project.model.execution.ExecutionFactory;
import org.fortiss.af3.project.model.typesystem.ITypeSystem;
import org.fortiss.af3.project.model.typesystem.TypesystemFactory;
import org.osgi.framework.Version;

public final class ProjectModelElementFactory {
    public static FileProject createFileProject(String name, ProjectConfiguration pconf) {
        FileProject project = AF3ProjectFactory.eINSTANCE.createFileProject();
        Version version = AF3ProjectActivator.getDefault().getBundle().getVersion();
        project.setAf3Version(version.toString());
        project.setName(name);
        project.getRootElements().add((Object)pconf);
        return project;
    }

    public static ProjectConfiguration createProjectConfiguration() {
        return ProjectModelElementFactory.createProjectConfiguration(ProjectModelElementFactory.createDummyTypeSystem());
    }

    public static ITypeSystem createDummyTypeSystem() {
        return TypesystemFactory.eINSTANCE.createDummyTypeSystem();
    }

    public static ProjectConfiguration createProjectConfiguration(ITypeSystem ts) {
        ProjectConfiguration config = AF3ProjectFactory.eINSTANCE.createProjectConfiguration();
        TypeSystemConfiguration tsConfig = ConfigurationFactory.eINSTANCE.createTypeSystemConfiguration();
        config.getConfigurationElements().add((Object)tsConfig);
        tsConfig.setTypesystem(ts);
        return config;
    }

    public static ExecutionConfigurationStore createExecutionConfigurationStore() {
        return ExecutionFactory.eINSTANCE.createExecutionConfigurationStore();
    }

    public static ExecutionConfiguration createExecutionConfiguration() {
        ExecutionConfiguration execConf = ExecutionFactory.eINSTANCE.createExecutionConfiguration();
        execConf.setIdReference(0);
        execConf.setName("Execonf");
        execConf.setComment("");
        return execConf;
    }
}

