/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.fortiss.af3.project.AF3ProjectActivator;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.project.model.IProjectConfigurationElement;
import org.fortiss.af3.project.model.ProjectConfiguration;
import org.fortiss.af3.project.model.execution.ExecutionConfiguration;
import org.fortiss.af3.project.model.execution.ExecutionConfigurationStore;
import org.fortiss.af3.project.utils.ExternalFileUtils;
import org.fortiss.af3.project.utils.FileUtils;
import org.fortiss.af3.project.utils.ProjectModelElementFactory;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.service.listener.IPersistencyServiceListener;
import org.fortiss.tooling.kernel.utils.EMFResourceUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public final class ProjectUtils {
    public static <T extends IProjectConfigurationElement> T getProjectConfigurationElement(EObject element, Class<? extends T> clazz) {
        ProjectConfiguration projConfig = (ProjectConfiguration)KernelModelElementUtils.getRootElement((EObject)element, ProjectConfiguration.class);
        if (projConfig == null) {
            return null;
        }
        return (T)((IProjectConfigurationElement)ReflectionUtils.pickInstanceOf(clazz, projConfig.getConfigurationElements()));
    }

    public static ProjectConfiguration getProjectConfiguration(EObject element) {
        return (ProjectConfiguration)KernelModelElementUtils.getRootElement((EObject)element, ProjectConfiguration.class);
    }

    public static ExecutionConfiguration findExecutionConfiguration(int id, FileProject project) {
        return (ExecutionConfiguration)ProjectUtils.findElementById(id, project);
    }

    public static ExecutionConfiguration findExecutionConfiguration(FileProject project, String execConfName) {
        ExecutionConfigurationStore store = (ExecutionConfigurationStore)KernelModelElementUtils.getRootElement((EObject)project, ExecutionConfigurationStore.class);
        if (store != null) {
            for (ExecutionConfiguration execConf : store.getConfigurations()) {
                if (!execConf.getName().equals(execConfName)) continue;
                return execConf;
            }
        }
        return null;
    }

    public static ExecutionConfiguration findOrCreateExecutionConfigurationFor(INamedElement targetElement) {
        ExecutionConfiguration conf2;
        final ExecutionConfigurationStore store = (ExecutionConfigurationStore)KernelModelElementUtils.getRootElement((EObject)targetElement, ExecutionConfigurationStore.class);
        if (store == null) {
            return ProjectUtils.createStoreAndConfig((IIdLabeled)targetElement);
        }
        for (final ExecutionConfiguration conf2 : store.getConfigurations()) {
            if (conf2.getIdReference() != targetElement.getId()) continue;
            return conf2;
        }
        conf2 = ProjectModelElementFactory.createExecutionConfiguration();
        conf2.setName(targetElement.getName());
        conf2.setIdReference(targetElement.getId());
        ICommandStackService.getInstance().runAsCommand((EObject)targetElement, new Runnable(){

            @Override
            public void run() {
                IElementCompositorService.getInstance().compose((EObject)store, (EObject)conf2, null);
            }
        });
        return conf2;
    }

    private static ExecutionConfiguration createStoreAndConfig(final IIdLabeled targetElement) {
        final ExecutionConfigurationStore newStore = ProjectModelElementFactory.createExecutionConfigurationStore();
        ExecutionConfiguration conf = ProjectModelElementFactory.createExecutionConfiguration();
        conf.setIdReference(targetElement.getId());
        newStore.getConfigurations().add((Object)conf);
        ICommandStackService.getInstance().runAsCommand((EObject)targetElement, new Runnable(){

            @Override
            public void run() {
                EObject rootElement = IPersistencyService.getInstance().getTopLevelElementFor((EObject)targetElement).getRootModelElement();
                IElementCompositorService.getInstance().compose(rootElement, (EObject)newStore, null);
            }
        });
        return conf;
    }

    public static void ensureEclipseContainerProjectExists() {
        String absoluteProjectPath = FileUtils.PROJECT_DIR.getAbsolutePath();
        if (new File(absoluteProjectPath).isDirectory()) {
            return;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject("AF3-Project-Directory");
        try {
            if (project.exists()) {
                project.delete(false, (IProgressMonitor)new NullProgressMonitor());
            }
            project.create(null);
            project.open(null);
            EMFResourceUtils.refreshWorkspace();
        }
        catch (CoreException e) {
            LoggingUtils.error((Plugin)AF3ProjectActivator.getDefault(), (String)"Error during creating new project", (Throwable)e);
            LoggingUtils.showError((String)"Cannot create general project!");
        }
    }

    public static void importFileProject(URI sourceFileURI, URI targetFileURI) throws IOException {
        FileProject sourceFileProject = (FileProject)EMFResourceUtils.loadModelFromFile((URI)sourceFileURI);
        ProjectUtils.ensureEclipseContainerProjectExists();
        ExternalFileUtils.doCopyExternalDocuments(sourceFileProject, sourceFileURI, targetFileURI);
        InputStream inStream = URIConverter.INSTANCE.createInputStream(sourceFileURI);
        OutputStream outStream = URIConverter.INSTANCE.createOutputStream(targetFileURI);
        int size = FileSystemUtils.copy((InputStream)inStream, (OutputStream)outStream);
        if (size <= 0) {
            LoggingUtils.error((Plugin)AF3ProjectActivator.getDefault(), (String)("Failed to import " + sourceFileProject.getName() + ". Zero bytes were copied."));
        }
        IPersistencyService.getInstance().addTopLevelElementListener(ProjectUtils.createRenamingListener(sourceFileProject.getName(), targetFileURI));
        EMFResourceUtils.refreshWorkspace();
    }

    private static IPersistencyServiceListener createRenamingListener(final String originalName, URI targetFileURI) {
        final String newName = targetFileURI.lastSegment().replace("." + targetFileURI.fileExtension(), "");
        return new IPersistencyServiceListener(){

            public void topLevelElementAdded(ITopLevelElement element) {
                if (element.getRootModelElement() instanceof FileProject) {
                    FileProject fp = (FileProject)element.getRootModelElement();
                    if (element.getSaveableName().equals(newName + ".af3_23") && fp.getName().equals(originalName)) {
                        element.runAsCommand(() -> fp.setName(newName));
                        try {
                            try {
                                element.doSave((IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (IOException | CoreException e) {
                                LoggingUtils.error((Plugin)AF3ProjectActivator.getDefault(), (String)"Failed to rename the imported Project.", (Throwable)e);
                                IPersistencyService.getInstance().removeTopLevelElementListener((IPersistencyServiceListener)this);
                            }
                        }
                        finally {
                            IPersistencyService.getInstance().removeTopLevelElementListener((IPersistencyServiceListener)this);
                        }
                    }
                }
            }

            public void topLevelElementRemoved(ITopLevelElement element) {
            }

            public void topLevelElementLoaded(ITopLevelElement element) {
            }

            public void topLevelElementContentChanged(ITopLevelElement element) {
            }
        };
    }

    public static IIdLabeled findElementById(int id, FileProject project) {
        for (IProjectRootElement root : project.getRootElements()) {
            IIdLabeled foundElem = KernelModelElementUtils.findElementById((int)id, (EObject)root);
            if (foundElem == null) continue;
            return foundElem;
        }
        return null;
    }

    public static <T extends EObject> List<T> getAllElementsFromProjectByType(EObject context, Class<T> clazz) {
        FileProject project = context instanceof FileProject ? (FileProject)context : (FileProject)EcoreUtils.getFirstParentWithType((EObject)context, FileProject.class);
        if (project == null) {
            throw new IllegalArgumentException("The given context is either null or is not contained in a FileProject!");
        }
        return EcoreUtils.getChildrenWithType((EObject)project, clazz);
    }

    public static void saveProject(FileProject project, URI uri) throws IOException {
        Resource r = new ResourceSetImpl().createResource(uri);
        r.getContents().add((Object)project);
        r.save(EMFResourceUtils.buildOptionsMap());
    }
}

