/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.project.utils;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.project.model.typesystem.IComplexVar;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.af3.project.model.typesystem.IVariableScope;
import org.fortiss.af3.project.model.typesystem.VarBase;

public class VariableScopeUtils {
    public static IType getVarType(VarBase variable) {
        return VariableScopeUtils.getVarType(variable, variable);
    }

    public static IType getVarType(VarBase variable, EObject context) {
        if (variable instanceof IComplexVar) {
            return ((IComplexVar)((Object)variable)).getVarType(context);
        }
        IVariableDefinition definition = VariableScopeUtils.getVarDefinition(variable, context);
        if (definition != null) {
            return definition.getVariableType();
        }
        return null;
    }

    public static IVariableDefinition getVarDefinition(VarBase variable, EObject context) {
        if (variable instanceof IComplexVar) {
            return ((IComplexVar)((Object)variable)).getVarDefinition(context);
        }
        IVariableScope innermostScope = null;
        while (context != null && innermostScope == null) {
            if (context instanceof IVariableScope) {
                innermostScope = (IVariableScope)context;
            }
            context = context.eContainer();
        }
        if (innermostScope == null) {
            return null;
        }
        IVariableScope currentScope = innermostScope;
        while (currentScope != null) {
            IVariableDefinition def = currentScope.getDefinitionElement(variable);
            if (def != null) {
                return def;
            }
            currentScope = currentScope.getParentVariableScope();
        }
        return null;
    }

    public static IVariableDefinition getVarDefinition(VarBase variable) {
        return VariableScopeUtils.getVarDefinition(variable, variable);
    }

    public static IVariableScope getNearestDefiningScope(VarBase variable) {
        return VariableScopeUtils.getNearestDefiningScope(variable, variable);
    }

    public static IVariableScope getNearestDefiningScope(VarBase variable, EObject context) {
        while (context != null) {
            IVariableScope scope;
            IVariableDefinition def;
            if (context instanceof IVariableScope && (def = (scope = (IVariableScope)context).getDefinitionElement(variable)) != null) {
                return scope;
            }
            context = context.eContainer();
        }
        return null;
    }
}

