/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.variability.featuremodel.ui.editor.fx;

import java.util.HashMap;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import org.eclipse.emf.common.notify.Notification;
import org.fortiss.af3.variability.featuremodel.model.FeatureModel;
import org.fortiss.af3.variability.featuremodel.ui.editor.fx.FeatureModelFXEditorContentProvider;
import org.fortiss.af3.variability.featuremodel.ui.editor.fx.FeatureModelFXEditorUIProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.kernel.ui.extension.base.FXEditorBase;
import org.fortiss.tooling.kernel.utils.KernelServiceBasedModelListenerBase;
import org.fortiss.variability.model.IHasName;
import org.fortiss.variability.model.features.AbstractCrossFeatureConstraint;
import org.fortiss.variability.util.VariabilityUtils;

public class FeatureModelFXEditor
extends FXEditorBase<FeatureModel> {
    private static final int TREE_INIT_EXPAND_LEVEL = 10;
    static final String FEATURE_CONSTRAINT_NONE = "None";
    private KernelServiceBasedModelListenerBase<FeatureModel> modelListener;
    private DynamicTreeTableViewer<IHasName> treeTableViewer;
    private TextField filterWidget;

    protected Parent createSceneRoot() {
        this.modelListener = new KernelServiceBasedModelListenerBase<FeatureModel>((FeatureModel)this.getEditedObject()){

            public void updateComplete(List<Notification> notifications) {
                FeatureModelFXEditor.this.treeTableViewer.update();
            }
        };
        this.modelListener.register();
        FeatureModelFXEditorContentProvider contentProvider = new FeatureModelFXEditorContentProvider();
        FeatureModelFXEditorUIProvider uiProvider = new FeatureModelFXEditorUIProvider(this);
        BorderPane pane = new BorderPane();
        this.filterWidget = new TextField();
        this.filterWidget.textProperty().addListener((obs, oVal, nVal) -> {
            contentProvider.setFilterExpression((String)nVal);
            this.treeTableViewer.update();
        });
        boolean showRoot = true;
        this.treeTableViewer = new DynamicTreeTableViewer((Object)((IHasName)this.getEditedObject()), true, 10, (DynamicTreeContentProviderBase)contentProvider, (DynamicTreeTableUIProviderBase)uiProvider);
        this.treeTableViewer.addColumn("Features", 200);
        this.treeTableViewer.addComboColumn("Related Features", 200, e -> {
            HashMap<String, String> res = new HashMap<String, String>();
            if (e instanceof AbstractCrossFeatureConstraint) {
                List possibleTargets = VariabilityUtils.getAllLegalConstraintTargets((AbstractCrossFeatureConstraint)((AbstractCrossFeatureConstraint)e));
                possibleTargets.stream().forEach(t -> {
                    String string = res.put((String)t, t.getName());
                });
                res.put(FEATURE_CONSTRAINT_NONE, FEATURE_CONSTRAINT_NONE);
                return res;
            }
            return new HashMap();
        });
        this.treeTableViewer.addColumn("Comments", 200);
        pane.setTop((Node)this.filterWidget);
        pane.setCenter((Node)this.treeTableViewer.getControl());
        return pane;
    }

    public void dispose() {
        if (this.modelListener != null) {
            this.modelListener.unregister();
        }
        super.dispose();
    }
}

