/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.variability.featuremodel.ui.editor.fx;

import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.input.Dragboard;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.fortiss.af3.variability.featuremodel.model.AlternativeFeature;
import org.fortiss.af3.variability.featuremodel.model.CompositionalFeature;
import org.fortiss.af3.variability.featuremodel.model.CrossFeatureConstraint;
import org.fortiss.af3.variability.featuremodel.model.FeatureModel;
import org.fortiss.af3.variability.featuremodel.ui.editor.fx.FeatureModelFXEditor;
import org.fortiss.tooling.base.ui.utils.ContextMenuUtils;
import org.fortiss.tooling.base.ui.utils.FXDNDUtils;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.ext.variability.util.VariabilityUtils;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.ui.service.IContextMenuService;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.variability.model.IHasName;
import org.fortiss.variability.model.features.AbstractCrossFeatureConstraint;
import org.fortiss.variability.model.features.AbstractFeature;

public class FeatureModelFXEditorUIProvider
extends DynamicTreeTableUIProviderBase<IHasName> {
    private static final int COL_IDX_FEATURE_NAME = 0;
    private static final int COL_IDX_RELATED_FEATURE = 1;
    private static final int COL_IDX_COMMENTS = 2;
    private final FeatureModelFXEditor editor;

    public FeatureModelFXEditorUIProvider(FeatureModelFXEditor editor) {
        this.editor = editor;
    }

    public String getLabel(IHasName element, int column) {
        if (column == 0) {
            return element.getName();
        }
        if (column == 1) {
            if (element instanceof AbstractCrossFeatureConstraint) {
                AbstractFeature constraintTarget = ((AbstractCrossFeatureConstraint)element).getTarget();
                if (constraintTarget != null) {
                    return constraintTarget.getName();
                }
                return "None";
            }
            return null;
        }
        if (column == 2 && element instanceof INamedCommentedElement) {
            String comment = ((INamedCommentedElement)element).getComment();
            return comment != null ? comment : "";
        }
        return null;
    }

    public boolean isEditable(int column) {
        return true;
    }

    public boolean isElementEditable(int column, IHasName element) {
        return column == 0 || column == 1 && element instanceof AbstractCrossFeatureConstraint || column == 2;
    }

    public void updateValue(IHasName element, int column, Object value) {
        if (column == 0 && value instanceof String) {
            String newName = (String)value;
            if (newName.isEmpty()) {
                MessageUtilsExtended.showInfoInUIThread((String)"Empty Feature name", (String)("The Feature \"" + element.getName() + "\" must not have an empty name.\n\n" + VariabilityUtils.FEATURE_NAME_ERROR_MSG));
                return;
            }
            List literals = org.fortiss.variability.util.VariabilityUtils.getLiteralsWithName((EObject)element, (String)newName);
            if (literals.size() >= 1) {
                IProjectRootElement rootElement = (IProjectRootElement)EcoreUtils.getFirstParentWithType((EObject)((EObject)literals.get(0)), IProjectRootElement.class);
                MessageUtilsExtended.showInfoInUIThread((String)"Feature name not available", (String)("The feature name \"" + newName + "\" is already used in " + rootElement.getName()));
                return;
            }
            ICommandStackService.getInstance().runAsCommand((EObject)element, () -> element.setName(newName));
        }
        if (column == 1) {
            if (!(element instanceof CrossFeatureConstraint)) {
                return;
            }
            CrossFeatureConstraint constraint = (CrossFeatureConstraint)element;
            if (value instanceof String && value.equals("None")) {
                ICommandStackService.getInstance().runAsCommand((EObject)constraint, () -> constraint.setTarget(null));
            }
            if (value instanceof AbstractFeature) {
                ICommandStackService.getInstance().runAsCommand((EObject)constraint, () -> constraint.setTarget((AbstractFeature)value));
            }
        }
        if (column == 2 && value instanceof String && element instanceof INamedCommentedElement) {
            String newComment = (String)value;
            INamedCommentedElement namedCommented = (INamedCommentedElement)element;
            String oldComment = namedCommented.getComment();
            if (newComment.equals(oldComment) || newComment.isEmpty() && oldComment == null) {
                return;
            }
            ICommandStackService.getInstance().runAsCommand((EObject)element, () -> namedCommented.setComment(newComment));
        }
    }

    public boolean dragOver(IHasName item, Dragboard dragboard) {
        return item != null && FXDNDUtils.canCompose((Dragboard)dragboard, (EObject)item);
    }

    public boolean dropClipboardContent(IHasName element, Dragboard dragboard) {
        return FXDNDUtils.compose((Dragboard)dragboard, (EObject)element);
    }

    public Node getIconNode(IHasName element, int column) {
        AbstractFeature relatedFeature;
        if (element == null) {
            return null;
        }
        if (column == 0) {
            Node fxIcon = IModelElementHandlerService.getInstance().getFXIcon((EObject)element);
            return fxIcon;
        }
        if (column == 1 && element instanceof AbstractCrossFeatureConstraint && (relatedFeature = ((AbstractCrossFeatureConstraint)element).getTarget()) != null) {
            Node fxIcon = IModelElementHandlerService.getInstance().getFXIcon((EObject)relatedFeature);
            return fxIcon;
        }
        return null;
    }

    public ContextMenu createContextMenu(IHasName element, int column) {
        if (element == null || column != 0) {
            return null;
        }
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().addAll((Collection)ContextMenuUtils.createPrototypeMenu((EObject)element, null, (boolean)false));
        contextMenu.getItems().add((Object)ContextMenuUtils.createDeleteMenu((EObject)element));
        contextMenu.getItems().addAll((Collection)IContextMenuService.getInstance().getFXMenuItemsForElement((EObject)element, null));
        return contextMenu;
    }

    public void select(IHasName oldValue, IHasName newValue) {
        StructuredSelection selection = newValue == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)newValue);
        this.editor.getSite().getSelectionProvider().setSelection((ISelection)selection);
    }

    public String getTooltip(IHasName element, int column) {
        if (column == 0) {
            if (element instanceof FeatureModel) {
                return "This is the root node for this feature model. It cannot be declared optional and hence cannot be deselected for instantiation of the product-line.";
            }
            if (element instanceof CompositionalFeature) {
                String parentName = ((INamedElement)element.eContainer()).getName();
                if (element.eContainer() instanceof AlternativeFeature) {
                    return "This is one alternative that can be selected for \"" + parentName + "\" for the instantiation of the product-line.";
                }
                Object tip = "";
                CompositionalFeature feature = (CompositionalFeature)element;
                if (feature.getSubFeatures().size() > 0) {
                    tip = "This compositional feature enables an arbitrary number of optional sub-features to be selected for the instantiation of the product-line. ";
                }
                tip = feature.isOptional() ? (String)tip + "\nThis feature can optionally be selected for the instantiation of the product-line. Deselect \"Optional\" in the Properties view to make it mandatory." : (String)tip + "\nThis feature is mandatory for all configurations in which the parent feature \"" + parentName + "\" is selected. Select \"Optional\" in the Properties view to make it optional. ";
                return ((String)tip).trim();
            }
            if (element instanceof AlternativeFeature) {
                return "This alternative feature requires to select exactly one sub-feature for the instantiation of the product-line.";
            }
            if (element instanceof CrossFeatureConstraint) {
                return "This constraint restricts which combination with another feature is a legal selection for the instantiation of the product-line.";
            }
        }
        return super.getTooltip((Object)element, column);
    }
}

