/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.variability.featuremodel.ui.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fortiss.af3.variability.featuremodel.model.AlternativeFeature;
import org.fortiss.af3.variability.featuremodel.model.CompositionalFeature;
import org.fortiss.af3.variability.featuremodel.model.CrossFeatureConstraint;
import org.fortiss.af3.variability.featuremodel.model.FeatureBase;
import org.fortiss.af3.variability.featuremodel.model.FeatureModel;
import org.fortiss.af3.variability.featuremodel.ui.AF3VariabilityFeatureModelUIActivator;
import org.fortiss.tooling.kernel.ui.extension.base.NamedCommentedModelElementHandlerBase;

public final class FeatureModelHandlers {

    public static class AlternativeFeatureHandler
    extends IFeatureHandlerBase<AlternativeFeature> {
        @Override
        public List<EObject> getSubnodes(AlternativeFeature element) {
            ArrayList<EObject> subnodes = new ArrayList<EObject>();
            subnodes.addAll(super.getSubnodes(element));
            subnodes.addAll((Collection<EObject>)element.getAlternatives());
            return subnodes;
        }

        protected String getPluginId() {
            return AF3VariabilityFeatureModelUIActivator.PLUGIN_ID;
        }

        protected String getIconPath(AlternativeFeature element) {
            return "icons/alternative.png";
        }
    }

    public static class CompositionalFeatureHandler
    extends IFeatureHandlerBase<CompositionalFeature> {
        @Override
        public List<EObject> getSubnodes(CompositionalFeature element) {
            ArrayList<EObject> ret = new ArrayList<EObject>();
            ret.addAll(super.getSubnodes(element));
            ret.addAll((Collection<EObject>)element.getSubFeatures());
            return ret;
        }

        protected String getPluginId() {
            return AF3VariabilityFeatureModelUIActivator.PLUGIN_ID;
        }

        protected String getIconPath(CompositionalFeature element) {
            if (element.getSubFeatures().size() > 0) {
                return "icons/composed.png";
            }
            return "icons/feature.png";
        }
    }

    public static class CrossFeatureConstraintHandler
    extends NamedCommentedModelElementHandlerBase<CrossFeatureConstraint> {
        protected String getPluginId() {
            return AF3VariabilityFeatureModelUIActivator.PLUGIN_ID;
        }

        protected String getIconPath(CrossFeatureConstraint element) {
            switch (element.getType()) {
                case REQUIRES: {
                    return "icons/requires.gif";
                }
                case EXCLUDES: {
                    return "icons/excludes.gif";
                }
            }
            return this.getIconPath(element);
        }
    }

    public static class FeatureModelHandler
    extends NamedCommentedModelElementHandlerBase<FeatureModel> {
        public List<EObject> getSubnodes(FeatureModel element) {
            ArrayList<EObject> ret = new ArrayList<EObject>();
            ret.addAll(super.getSubnodes((EObject)element));
            ret.addAll((Collection<EObject>)element.getSubFeatures());
            return ret;
        }

        protected String getPluginId() {
            return AF3VariabilityFeatureModelUIActivator.PLUGIN_ID;
        }

        protected String getIconPath(FeatureModel element) {
            return "icons/composed.png";
        }
    }

    protected static abstract class IFeatureHandlerBase<T extends FeatureBase>
    extends NamedCommentedModelElementHandlerBase<T> {
        protected IFeatureHandlerBase() {
        }

        public List<EObject> getSubnodes(T element) {
            ArrayList<EObject> ret = new ArrayList<EObject>();
            ret.addAll((Collection<EObject>)element.getConstraints());
            return ret;
        }

        public ImageDescriptor getIconOverlay(T element) {
            if (element.isOptional()) {
                return AF3VariabilityFeatureModelUIActivator.getImageDescriptor("icons/optional.png");
            }
            return null;
        }

        public String getIconOverlayPath(T element) {
            if (element.isOptional()) {
                return "icons/optional.png";
            }
            return null;
        }
    }
}

