/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.variability.featuremodel.ui.refactoring;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fortiss.af3.variability.featuremodel.model.AlternativeFeature;
import org.fortiss.af3.variability.featuremodel.model.CompositionalFeature;
import org.fortiss.af3.variability.featuremodel.refactoring.FeaturesRefactoringUtils;
import org.fortiss.af3.variability.featuremodel.ui.AF3VariabilityFeatureModelUIActivator;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.variability.model.features.AbstractAlternativeFeature;
import org.fortiss.variability.model.features.AbstractCompositionalFeature;

public class FeatureTypeRefactoringContextMenuContributor
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection instanceof AlternativeFeature) {
            return Collections.singletonList(new ActionContributionItem((IAction)new AlternativeToCompositionalAction((AbstractAlternativeFeature)((AlternativeFeature)selection))));
        }
        if (selection instanceof CompositionalFeature) {
            return Collections.singletonList(new ActionContributionItem((IAction)new CompositionalToAlternativeAction((AbstractCompositionalFeature)((CompositionalFeature)selection))));
        }
        return Collections.emptyList();
    }

    public String getMenuSectionID() {
        return "bottommost";
    }

    private class AlternativeToCompositionalAction
    extends Action {
        private AbstractAlternativeFeature oldFeature;

        private AlternativeToCompositionalAction(AbstractAlternativeFeature feature) {
            this.oldFeature = feature;
        }

        public void run() {
            ICommandStackService.getInstance().runAsCommand((EObject)this.oldFeature, () -> FeaturesRefactoringUtils.refactorAlternativeToCompositionalFeature((AbstractAlternativeFeature)this.oldFeature));
        }

        public String getText() {
            return "Change type to Compositional Feature";
        }

        public ImageDescriptor getImageDescriptor() {
            return AF3VariabilityFeatureModelUIActivator.getImageDescriptor("icons/composed.png");
        }
    }

    private class CompositionalToAlternativeAction
    extends Action {
        private AbstractCompositionalFeature oldFeature;

        private CompositionalToAlternativeAction(AbstractCompositionalFeature feature) {
            this.oldFeature = feature;
        }

        public void run() {
            ICommandStackService.getInstance().runAsCommand((EObject)this.oldFeature, () -> FeaturesRefactoringUtils.refactorCompositionalToAlternativeFeature((AbstractCompositionalFeature)this.oldFeature));
        }

        public String getText() {
            return "Change type to Alternative Feature";
        }

        public ImageDescriptor getImageDescriptor() {
            return AF3VariabilityFeatureModelUIActivator.getImageDescriptor("icons/alternative.png");
        }
    }
}

