/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.constraint;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.constraint.IdConsistencyConstraintViolation;
import org.fortiss.tooling.kernel.constraint.IdUniquenessConstraintViolation;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedElement;

public class ConstraintMessage {
    private static String formatElementName(EObject element) {
        return ConstraintMessage.formatElementName(element, true);
    }

    private static String formatElementName(EObject element, boolean offspring) {
        String elementName;
        if (element instanceof INamedElement && (elementName = ((INamedElement)element).getName()) != null && !elementName.isEmpty()) {
            return "\"" + elementName + "\"";
        }
        if (element != null && element.eContainer() != null) {
            elementName = ConstraintMessage.formatElementName(element.eContainer(), false);
            return offspring ? "<unnamed offspring of> " + elementName : elementName;
        }
        return "<unnamed>";
    }

    public static IdUniquenessConstraintViolation<IIdLabeled> createDuplicateIdViolation(IIdLabeled element, IIdLabeled duplicate) {
        return new IdUniquenessConstraintViolation<IIdLabeled>(element, "The ID " + element.getId() + " of model element " + ConstraintMessage.formatElementName(element) + " has already been assigned to model element " + ConstraintMessage.formatElementName(duplicate) + ".");
    }

    public static IdConsistencyConstraintViolation<IIdLabeled> createConsistencyIdViolation(IIdLabeled element, String persistedId) {
        return new IdConsistencyConstraintViolation<IIdLabeled>(element, "The ID " + element.getId() + " of model element " + ConstraintMessage.formatElementName(element) + " does not match the element's persisted ID " + persistedId + ".");
    }
}

