/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.constraint;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.constraint.ConstraintMessage;
import org.fortiss.tooling.kernel.constraint.IdConsistencyConstraintViolation;
import org.fortiss.tooling.kernel.extension.base.ConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class IdConsistencyChecker
extends ConstraintCheckerBase<EObject> {
    @Override
    public List<IdConsistencyConstraintViolation<IIdLabeled>> apply(EObject rootObject) {
        ArrayList<IdConsistencyConstraintViolation<IIdLabeled>> result = new ArrayList<IdConsistencyConstraintViolation<IIdLabeled>>();
        IPersistencyService ps = IPersistencyService.getInstance();
        ITopLevelElement topLevelElement = ps.getTopLevelElementFor(rootObject);
        if (topLevelElement != null) {
            for (IIdLabeled current : EcoreUtils.getChildrenWithType(rootObject, IIdLabeled.class)) {
                String persistedId = topLevelElement.getId(current);
                if (new Integer(current.getId()).toString().equals(persistedId)) continue;
                result.add(ConstraintMessage.createConsistencyIdViolation(current, persistedId));
            }
        }
        return result;
    }
}

