/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.extension.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.extension.IPrototypeProvider;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.extension.data.PrototypeCategory;

public abstract class PrototypeProviderBase
implements IPrototypeProvider {
    private static final boolean CATEGORY_EXPANDED_BY_DEFAULT = false;
    protected final List<Prototype> prototypes = new ArrayList<Prototype>();
    protected final Map<String, PrototypeCategory> categories = new HashMap<String, PrototypeCategory>();

    public PrototypeProviderBase() {
        this.registerPrototypes();
    }

    @Override
    public final void refreshCurrentPrototypes() {
        this.prototypes.clear();
        this.registerPrototypes();
    }

    protected abstract void registerPrototypes();

    protected final void registerPrototype(String name, EObject prototype, String categoryName) {
        this.registerPrototype(name, prototype, categoryName, false, OptionalInt.empty());
    }

    protected final void registerPrototype(String name, EObject prototype, String categoryName, int priority) {
        this.registerPrototype(name, prototype, categoryName, false, OptionalInt.of(priority));
    }

    protected final void registerPrimaryPrototype(String name, EObject prototype, String categoryName) {
        this.registerPrototype(name, prototype, categoryName, true, OptionalInt.empty());
    }

    protected final void registerPrimaryPrototype(String name, EObject prototype, String categoryName, int priority) {
        this.registerPrototype(name, prototype, categoryName, true, OptionalInt.of(priority));
    }

    private final void registerPrototype(String name, EObject prototype, String categoryName, boolean primary, OptionalInt priority) {
        Prototype prototypeObject = priority.isPresent() ? new Prototype(name, prototype, primary, priority.getAsInt()) : new Prototype(name, prototype, primary);
        this.prototypes.add(prototypeObject);
        this.registerElementInCategory(prototypeObject, categoryName);
    }

    @Override
    public final List<Prototype> getPrototypes() {
        return CollectionUtils.asUnmodifiable(this.prototypes);
    }

    private void registerElementInCategory(Prototype element, String category) {
        PrototypeCategory cat = this.registerPrototypeCategory(category, false);
        Object[] objectArray = cat.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Prototype prototype;
            Object object = objectArray[n2];
            if (object instanceof Prototype && (prototype = (Prototype)object).getName().equals(element.getName())) {
                cat.replace(prototype, element);
                return;
            }
            ++n2;
        }
        cat.add(element);
    }

    protected PrototypeCategory registerPrototypeCategory(String category, boolean expandByDefault) {
        PrototypeCategory cat = this.categories.get(category);
        if (cat == null) {
            cat = new PrototypeCategory(category);
            cat.setExpandedByDefaultStatus(expandByDefault);
            this.categories.put(category, cat);
        }
        return cat;
    }

    protected PrototypeCategory registerPrototypeCategory(PrototypeCategory parent, String category, boolean expandByDefault) {
        PrototypeCategory cat = this.registerPrototypeCategory(category, expandByDefault);
        parent.add(cat);
        cat.setPrototypeCategoryParent(parent);
        return cat;
    }

    protected void setPrototypeCategoryPriority(String category, int priority) throws IllegalArgumentException {
        PrototypeCategory cat = this.categories.get(category);
        if (cat == null) {
            throw new IllegalArgumentException("Cannot set category priority since no prototype category exists with the given name '" + category + "'.");
        }
        cat.setPriority(priority);
    }

    @Override
    public List<PrototypeCategory> getCategories() {
        ArrayList<PrototypeCategory> result = new ArrayList<PrototypeCategory>();
        result.addAll(this.categories.values());
        return result;
    }

    @Override
    public final String getUniqueID(Prototype prototype) {
        if (!this.prototypes.contains(prototype)) {
            return null;
        }
        String categoryName = "";
        for (PrototypeCategory category : this.getCategories()) {
            Object[] objectArray = category.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof Prototype && object.equals(prototype)) {
                    categoryName = category.getName();
                    break;
                }
                ++n2;
            }
            if (!categoryName.isBlank()) break;
        }
        return this.getClass().getName() + "/" + categoryName + "/" + prototype.getName();
    }

    @Override
    public final Prototype getPrototypeByID(String id) {
        String[] idSplit = id.split("/");
        if (idSplit.length != 3) {
            return null;
        }
        String className = this.getClass().getName();
        if (!idSplit[0].equals(className)) {
            return null;
        }
        if (!idSplit[1].isBlank() && this.categories.containsKey(idSplit[1])) {
            PrototypeCategory category = this.categories.get(idSplit[1]);
            Object[] objectArray = category.getChildren();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Prototype prototype;
                Object object = objectArray[n2];
                if (object instanceof Prototype && (prototype = (Prototype)object).getName().equals(idSplit[2])) {
                    return prototype;
                }
                ++n2;
            }
        } else {
            for (Prototype prototype : this.prototypes) {
                if (!prototype.getName().equals(idSplit[2])) continue;
                return prototype;
            }
        }
        return null;
    }
}

