/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.extension.data;

import java.util.Comparator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;

public interface IConstraintViolation<T extends EObject>
extends IAdaptable {
    public static final Comparator<ESeverity> SEVERITY_DIRECT_COMPARATOR = new Comparator<ESeverity>(){

        @Override
        public int compare(ESeverity sev0, ESeverity sev1) {
            return ESeverity.getIntSeverity(sev0) - ESeverity.getIntSeverity(sev1);
        }
    };
    public static final Comparator<IConstraintViolation<? extends EObject>> SEVERITY_COMPARATOR = new Comparator<IConstraintViolation<? extends EObject>>(){

        @Override
        public int compare(IConstraintViolation<? extends EObject> arg0, IConstraintViolation<? extends EObject> arg1) {
            ESeverity sev0 = arg0.getSeverity();
            return SEVERITY_DIRECT_COMPARATOR.compare(sev0, arg1.getSeverity());
        }
    };

    public T getSource();

    public EObject getContainer();

    public ESeverity getSeverity();

    public String getExplanation();

    public IQuickFixHandler getQuickFixHandler();

    public static enum ESeverity {
        FATAL(-5),
        ERROR(-3),
        WARNING(-1),
        INFO(1),
        DEBUG(5),
        NONE(10000);

        private final int level;

        private ESeverity(int level) {
            this.level = level;
        }

        public static int getIntSeverity(ESeverity severity) {
            return severity.level;
        }

        public static ESeverity lowest() {
            return NONE;
        }
    }

    public static interface IQuickFixHandler {
        public void applyQuickFix();
    }
}

