/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.extension.data;

import java.util.Comparator;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class Prototype {
    private final String name;
    protected final EObject prototype;
    private final boolean isPrimary;
    private final int prototypePriority;

    public Prototype(String name, EObject prototype, boolean isPrimary) {
        this.name = name;
        this.prototype = prototype;
        this.isPrimary = isPrimary;
        this.prototypePriority = 0;
    }

    public Prototype(String name, EObject prototype, boolean isPrimary, int priority) {
        this.name = name;
        this.prototype = prototype;
        this.isPrimary = isPrimary;
        this.prototypePriority = priority;
    }

    public String getName() {
        return this.name;
    }

    public EObject getPrototype() {
        return this.prototype;
    }

    public EObject getPrototypeCopy() {
        return EcoreUtils.copy(this.prototype);
    }

    public int getPriority() {
        return this.prototypePriority;
    }

    public String toString() {
        return "Prototype for: " + this.name;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public static class PrototypeComparator
    implements Comparator<Prototype> {
        @Override
        public int compare(Prototype p1, Prototype p2) {
            boolean isP1RootElement = p1.getPrototype() instanceof IProjectRootElement;
            boolean isP2RootElement = p2.getPrototype() instanceof IProjectRootElement;
            if (isP1RootElement && !isP2RootElement) {
                return -1;
            }
            if (isP2RootElement && !isP1RootElement) {
                return 1;
            }
            if (p1.isPrimary && !p2.isPrimary) {
                return -1;
            }
            if (p2.isPrimary && !p1.isPrimary) {
                return 1;
            }
            if (p1.getPriority() == p2.getPriority()) {
                return p1.getName().compareTo(p2.getName());
            }
            return -Integer.compare(p1.getPriority(), p2.getPriority());
        }
    }
}

