/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.extension.data;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.fortiss.tooling.kernel.extension.data.Prototype;

public class PrototypeCategory {
    private final String categoryName;
    private PrototypeCategory parentCategory;
    private int categoryPriority;
    private boolean expandedByDefault;
    private Set<Prototype> children = new TreeSet<Prototype>(new Prototype.PrototypeComparator());
    private Set<PrototypeCategory> subCategories = new HashSet<PrototypeCategory>();

    public PrototypeCategory(String category) {
        this.categoryName = category;
        this.categoryPriority = 0;
        this.expandedByDefault = false;
    }

    public int getPriority() {
        return this.categoryPriority;
    }

    public void setPriority(int priority) {
        this.categoryPriority = priority;
    }

    public boolean getExpandedByDefaultStatus() {
        return this.expandedByDefault;
    }

    public void setExpandedByDefaultStatus(boolean shouldBeExpanded) {
        this.expandedByDefault = shouldBeExpanded;
    }

    public void add(Prototype prototype) {
        this.children.add(prototype);
    }

    public void add(PrototypeCategory subCat) {
        this.subCategories.add(subCat);
    }

    public void replace(Prototype oldPrototype, Prototype newPrototype) {
        if (this.children.remove(oldPrototype)) {
            this.children.add(newPrototype);
        }
    }

    public Object[] getChildren() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.children);
        result.addAll(this.subCategories);
        return result.toArray();
    }

    public String getName() {
        return this.categoryName;
    }

    public void setPrototypeCategoryParent(PrototypeCategory parent) {
        this.parentCategory = parent;
    }

    public PrototypeCategory getParentCategory() {
        return this.parentCategory;
    }

    public String toString() {
        return "Prototype category: " + this.categoryName;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public static class PrototypeCategoryComparator
    implements Comparator<PrototypeCategory> {
        @Override
        public int compare(PrototypeCategory category1, PrototypeCategory category2) {
            int result = category1.getPriority() - category2.getPriority();
            if (result == 0) {
                result = -category1.getName().compareTo(category2.getName());
            }
            return result;
        }
    }
}

