/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.extension.data;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.fortiss.tooling.kernel.extension.ITransformationProvider;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.ChainTransformationFailedException;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;

public final class TransformationProviderChain {
    private final List<ITransformationProvider> providerList = new LinkedList<ITransformationProvider>();

    public TransformationProviderChain(List<ITransformationProvider> providers) {
        Assert.isNotNull(providers);
        Assert.isTrue((!providers.isEmpty() ? 1 : 0) != 0);
        this.providerList.addAll(providers);
    }

    public Object transform(Object source, ITransformationContext context) throws ChainTransformationFailedException {
        LinkedList<Object> results = new LinkedList<Object>();
        for (ITransformationProvider provider : this.providerList) {
            if (!provider.canTransform(source, context)) {
                throw new ChainTransformationFailedException(this, provider, results, null);
            }
            try {
                source = provider.transform(source, context);
            }
            catch (TransformationFailedException e) {
                throw new ChainTransformationFailedException(this, provider, results, e);
            }
            results.add(source);
        }
        return source;
    }
}

