/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.ICommandLineSwitchHandler;
import org.fortiss.tooling.kernel.service.ICommandLineInterfaceService;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class CommandLineInterfaceService
implements ICommandLineInterfaceService {
    private static CommandLineInterfaceService INSTANCE = new CommandLineInterfaceService();
    private boolean handlersExecuted = false;
    private Map<String, ICommandLineSwitchHandler> switchHandlerMap = new HashMap<String, ICommandLineSwitchHandler>();

    private CommandLineInterfaceService() {
    }

    public static synchronized CommandLineInterfaceService getInstance() {
        return INSTANCE;
    }

    @Override
    public void executeHandlers() {
        if (this.handlersExecuted) {
            LoggingUtils.error(ToolingKernelActivator.getDefault(), "The " + CommandLineInterfaceService.class.getSimpleName() + " was asked more than one to process command line switches. The subsequent calls were NOT executed. Please report this issue to the developers.");
            return;
        }
        this.handlersExecuted = true;
        String[] args = Platform.getApplicationArgs();
        int cliIdx = 0;
        while (cliIdx < args.length) {
            String cliSwitch = args[cliIdx];
            ICommandLineSwitchHandler cliHandler = this.switchHandlerMap.get(cliSwitch);
            if (cliHandler != null) {
                String argument;
                argument = cliHandler.hasAdditionalArgument() ? (argument = args[++cliIdx]) : null;
                cliHandler.handleCLISwitch(argument);
            } else {
                LoggingUtils.error(ToolingKernelActivator.getDefault(), "Could not parse the argument " + cliSwitch + ".");
            }
            ++cliIdx;
        }
    }

    @Override
    public void registerHandler(String cliSwitch, ICommandLineSwitchHandler cliHandler) {
        if (this.switchHandlerMap.containsKey(cliSwitch)) {
            ICommandLineSwitchHandler activeHandler = this.switchHandlerMap.get(cliSwitch);
            LoggingUtils.error(ToolingKernelActivator.getDefault(), "The CLI switch " + cliSwitch + " is already registered with the handler " + activeHandler.getClass().getSimpleName() + " and won't be replaced.");
            return;
        }
        this.switchHandlerMap.put(cliSwitch, cliHandler);
    }
}

