/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class CommandStackService
implements ICommandStackService,
IIntrospectiveKernelService {
    private static final CommandStackService INSTANCE = new CommandStackService();

    public static CommandStackService getInstance() {
        return INSTANCE;
    }

    public void initializeService() {
    }

    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService(this);
    }

    @Override
    public String getIntrospectionLabel() {
        return "Command Stack Service";
    }

    @Override
    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThis service manages the command stack that provides the infrastructure needed to make changes to models.\nIt provides the following features:\n - Bridge between command stack and undo/redo actions\n - Bridge between command stack and editors\n - Management of dirty state of models.";
    }

    @Override
    public void addCommandStackListener(ITopLevelElement target, CommandStackListener listener) {
        if (target != null) {
            target.addCommandStackListener(listener);
        }
    }

    @Override
    public void removeCommandStackListener(ITopLevelElement target, CommandStackListener listener) {
        if (target != null) {
            target.removeCommandStackListener(listener);
        } else {
            IPersistencyService ps = IPersistencyService.getInstance();
            for (ITopLevelElement top : ps.getTopLevelElements()) {
                top.removeCommandStackListener(listener);
            }
        }
    }

    @Override
    public void runAsCommand(EObject target, Runnable runner) {
        IPersistencyService ps = IPersistencyService.getInstance();
        ITopLevelElement context = ps.getTopLevelElementFor(target);
        context.runAsCommand(runner);
    }

    @Override
    public boolean canUndo(EObject target) {
        IPersistencyService ps = IPersistencyService.getInstance();
        ITopLevelElement context = ps.getTopLevelElementFor(target);
        return context != null && context.canUndo();
    }

    @Override
    public boolean canRedo(EObject target) {
        IPersistencyService ps = IPersistencyService.getInstance();
        ITopLevelElement context = ps.getTopLevelElementFor(target);
        return context != null && context.canRedo();
    }

    @Override
    public void undo(EObject target) {
        IPersistencyService ps = IPersistencyService.getInstance();
        ps.getTopLevelElementFor(target).undo();
    }

    @Override
    public void redo(EObject target) {
        IPersistencyService ps = IPersistencyService.getInstance();
        ps.getTopLevelElementFor(target).redo();
    }

    @Override
    public boolean isDirty(EObject target) {
        IPersistencyService ps = IPersistencyService.getInstance();
        ITopLevelElement context = ps.getTopLevelElementFor(target);
        return context != null && context.isDirty();
    }

    @Override
    public void doSave(EObject target, IProgressMonitor monitor) {
        IPersistencyService ps = IPersistencyService.getInstance();
        ITopLevelElement context = ps.getTopLevelElementFor(target);
        if (context != null && context.isDirty()) {
            try {
                context.doSave(monitor);
            }
            catch (Exception e) {
                LoggingUtils.error(ToolingKernelActivator.getDefault(), "Error while saving.", e);
            }
        }
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    @Override
    public Collection<IIntrospectionItem> getIntrospectionItems() {
        return null;
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return null;
    }
}

