/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.extension.IConnectionCompositor;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.items.ConnectionCompositorKISSDetailsItem;
import org.fortiss.tooling.kernel.service.IConnectionCompositorService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.base.EObjectAware2ServiceBase;

public class ConnectionCompositorService
extends EObjectAware2ServiceBase<IConnectionCompositor<EObject, EObject, EObject>>
implements IConnectionCompositorService {
    private static final ConnectionCompositorService INSTANCE = new ConnectionCompositorService();
    private static final String EXTENSION_POINT_NAME = "org.fortiss.tooling.kernel.modelConnectionCompositor";
    private static final String CONFIGURATION_ELEMENT_NAME = "modelConnectionCompositor";
    private static final String ATTRIBUTE_NAME = "modelConnectionCompositor";

    public static ConnectionCompositorService getInstance() {
        return INSTANCE;
    }

    @Override
    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService(this);
    }

    @Override
    public void registerConnectionCompositor(IConnectionCompositor<EObject, EObject, EObject> compositor, Class<?> sourceClass, Class<?> targetClass) {
        this.addHandler(sourceClass, targetClass, compositor);
    }

    @Override
    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThis service allows the registration of connection compositors.\nConnection compositors are responsible for linking two model elements,\nwhile adding the link element as a child to a third model element, e.g.,\ncreating an edge between two graph nodes and adding it to the set of edges stored with the graph element.\n\nThe service extension point is 'org.fortiss.tooling.kernel.modelConnectionCompositor'.";
    }

    @Override
    public boolean canConnect(EObject source, EObject target, EObject parent, IConnectionCompositionContext context) {
        return this.findWorkingConnector(source, target, parent, context) != null;
    }

    @Override
    public boolean connect(EObject source, EObject target, EObject parent, IConnectionCompositionContext context) {
        IConnectionCompositor<EObject, EObject, EObject> connector = this.findWorkingConnector(source, target, parent, context);
        return connector.connect(source, target, parent, context);
    }

    @Override
    public boolean canReconnect(EObject connection, EObject source, EObject target, IConnectionCompositionContext context) {
        return this.findWorkingReconnector(connection, source, target, context) != null;
    }

    @Override
    public boolean reconnect(EObject connection, EObject source, EObject target, IConnectionCompositionContext context) {
        IConnectionCompositor<EObject, EObject, EObject> connector = this.findWorkingReconnector(connection, source, target, context);
        return connector.reconnect(connection, source, target, context);
    }

    @Override
    public boolean canDisconnect(EObject connection) {
        IConnectionCompositor<EObject, EObject, EObject> dc = this.findWorkingDisconnector(connection);
        return dc != null && dc.canDisconnect(connection);
    }

    @Override
    public boolean disconnect(EObject connection) {
        IConnectionCompositor<EObject, EObject, EObject> dc = this.findWorkingDisconnector(connection);
        return dc != null && dc.disconnect(connection);
    }

    private IConnectionCompositor<EObject, EObject, EObject> findWorkingConnector(EObject source, EObject target, EObject parent, IConnectionCompositionContext context) {
        List list = this.getRegisteredHandlers(source.getClass(), target.getClass());
        if (list == null) {
            return null;
        }
        for (IConnectionCompositor connector : list) {
            try {
                if (!connector.canConnect(source, target, parent, context)) continue;
                return connector;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    private IConnectionCompositor<EObject, EObject, EObject> findWorkingReconnector(EObject connection, EObject source, EObject target, IConnectionCompositionContext context) {
        List list = this.getRegisteredHandlers(source.getClass(), target.getClass());
        if (list == null) {
            return null;
        }
        for (IConnectionCompositor connector : list) {
            if (!connector.canReconnect(connection, source, target, context)) continue;
            return connector;
        }
        return null;
    }

    private IConnectionCompositor<EObject, EObject, EObject> findWorkingDisconnector(EObject connection) {
        for (Class c : this.handlersBySource.keySet()) {
            Map tmap = (Map)this.handlersBySource.get(c);
            for (Class c2 : tmap.keySet()) {
                List list = (List)tmap.get(c2);
                for (IConnectionCompositor comp : list) {
                    if (!comp.canDisconnect(connection)) continue;
                    return comp;
                }
            }
        }
        return null;
    }

    @Override
    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    @Override
    protected String getConfigurationElementName() {
        return "modelConnectionCompositor";
    }

    @Override
    protected String getHandlerClassAttribute() {
        return "modelConnectionCompositor";
    }

    @Override
    public String getIntrospectionLabel() {
        return "Connection Compositor Service";
    }

    public List<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return new ConnectionCompositorKISSDetailsItem(this.handlersBySource);
    }
}

