/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.extension.IConstraintChecker;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.introspection.items.ConstraintCheckerKISSDetailsItem;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.service.IConstraintCheckerService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.base.EObjectAwareServiceBase;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ConstraintCheckerService
extends EObjectAwareServiceBase<IConstraintChecker<EObject>>
implements IConstraintCheckerService,
IIntrospectiveKernelService {
    private static final ConstraintCheckerService INSTANCE = new ConstraintCheckerService();
    Map<Class<?>, List<IConstraintChecker<EObject>>> asynchronousConstraintCheckers = new HashMap();
    Map<IConstraintChecker<? extends EObject>, String> asynchronousCheckIdentifiers = new HashMap<IConstraintChecker<? extends EObject>, String>();
    Map<IConstraintChecker<? extends EObject>, Map<EObject, Job>> asynchronousCheckerJobs = new HashMap<IConstraintChecker<? extends EObject>, Map<EObject, Job>>();
    private static final String EXTENSION_POINT_NAME = "org.fortiss.tooling.kernel.modelElementConstraintChecker";
    private static final String CONFIGURATION_ELEMENT_NAME = "modelElementConstraintChecker";
    private static final String HANDLER_CLASS_ATTRIBUTE_NAME = "checker";
    private static List<Class<? extends EObject>> constraintCheckExclusionTypes = new ArrayList<Class<? extends EObject>>();

    public static ConstraintCheckerService getInstance() {
        return INSTANCE;
    }

    @Override
    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService(this);
    }

    @Override
    public <T extends EObject> void registerConstraintChecker(IConstraintChecker<T> checker, Class<? extends T> modelElementClass) {
        this.addHandler(modelElementClass, checker);
    }

    @Override
    public void registerTypeAsExcludedParentForConstraintChecks(Class<? extends EObject> clazz) {
        constraintCheckExclusionTypes.add(clazz);
    }

    @Override
    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThis service allows the registration of constraint checkers for models and/or model elements.\nConstraint checks are performed on model elements and may create constraint violations of different severities.\nViolations are usually displayed to the tool user and require some action to clear it.\n\nThe service extension point is 'org.fortiss.tooling.kernel.modelElementConstraintChecker'.";
    }

    @Override
    public List<IConstraintViolation<? extends EObject>> performAllConstraintChecksRecursively(EObject modelElement) {
        LinkedList<IConstraintViolation<? extends EObject>> result = new LinkedList<IConstraintViolation<? extends EObject>>();
        this.performConstraintCheck(modelElement, result);
        TreeIterator iter = modelElement.eAllContents();
        while (iter.hasNext()) {
            this.performConstraintCheck((EObject)iter.next(), result);
        }
        Collections.sort(result, IConstraintViolation.SEVERITY_COMPARATOR);
        return result;
    }

    @Override
    public List<IConstraintViolation<? extends EObject>> performAllConstraintChecks(EObject modelElement) {
        LinkedList<IConstraintViolation<? extends EObject>> result = new LinkedList<IConstraintViolation<? extends EObject>>();
        this.performConstraintCheck(modelElement, result);
        Collections.sort(result, IConstraintViolation.SEVERITY_COMPARATOR);
        return result;
    }

    private void performConstraintCheck(EObject modelElement, List<IConstraintViolation<? extends EObject>> violationList) {
        for (Class<? extends EObject> excludedClass : constraintCheckExclusionTypes) {
            EObject foundExcludedParent = EcoreUtils.getFirstParentWithType(modelElement, excludedClass);
            Class<? extends EObject> givenClass = modelElement.getClass();
            if (!givenClass.isAssignableFrom(excludedClass) && foundExcludedParent == null) continue;
            return;
        }
        List handlers = this.getRegisteredHandlers(modelElement.getClass());
        if (handlers == null) {
            return;
        }
        for (IConstraintChecker checker : handlers) {
            List<IConstraintViolation<EObject>> violation;
            if (!checker.isApplicable(modelElement) || (violation = checker.apply(modelElement)) == null) continue;
            violationList.addAll(violation);
        }
    }

    @Override
    public void performAllAsynchronousConstraintChecksRecursively(EObject modelElement, Consumer<List<IConstraintViolation<? extends EObject>>> addMarkers) {
        this.performAllAsynchronousConstraintChecks(modelElement, addMarkers);
        TreeIterator iter = modelElement.eAllContents();
        while (iter.hasNext()) {
            this.performAllAsynchronousConstraintChecks((EObject)iter.next(), addMarkers);
        }
    }

    @Override
    public void performAllAsynchronousConstraintChecks(final EObject modelElement, final Consumer<List<IConstraintViolation<? extends EObject>>> addMarkers) {
        List asyncHandlers = (List)ReflectionUtils.performNearestClassLookup(modelElement.getClass(), this.asynchronousConstraintCheckers);
        if (asyncHandlers == null) {
            return;
        }
        for (final IConstraintChecker checker : asyncHandlers) {
            String checkerIdentifier;
            Job checkerJob;
            Map<EObject, Job> jobs = this.asynchronousCheckerJobs.get(checker);
            if (jobs == null) {
                jobs = new HashMap<EObject, Job>();
                this.asynchronousCheckerJobs.put(checker, jobs);
            }
            if ((checkerJob = jobs.get(modelElement)) != null && checkerJob.getState() == 4) {
                checkerJob.cancel();
            }
            if ((checkerIdentifier = this.asynchronousCheckIdentifiers.get(checker)) == null) {
                checkerIdentifier = "Asynchronous Model Constraint Check";
            }
            Object modelIdentifier = "";
            if (modelElement instanceof INamedElement) {
                modelIdentifier = " on " + ((INamedElement)modelElement).getName();
            }
            checkerJob = new Job(checkerIdentifier + (String)modelIdentifier){

                protected IStatus run(IProgressMonitor monitor) {
                    ArrayList<IConstraintViolation<EObject>> results = new ArrayList<IConstraintViolation<EObject>>();
                    results.addAll(checker.apply(modelElement));
                    addMarkers.accept(results);
                    return Status.OK_STATUS;
                }
            };
            jobs.put(modelElement, checkerJob);
            checkerJob.setUser(false);
            checkerJob.schedule();
        }
    }

    @Override
    public List<IConstraintChecker<? extends EObject>> getAllConstraintCheckers(EObject modelElement) {
        return new ArrayList<IConstraintChecker<? extends EObject>>(this.getRegisteredHandlers(modelElement.getClass()));
    }

    @Override
    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    @Override
    protected String getConfigurationElementName() {
        return CONFIGURATION_ELEMENT_NAME;
    }

    @Override
    protected String getHandlerClassAttribute() {
        return HANDLER_CLASS_ATTRIBUTE_NAME;
    }

    @Override
    public String getIntrospectionLabel() {
        return "Constraint Checker Service";
    }

    public List<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return new ConstraintCheckerKISSDetailsItem(Collections.unmodifiableMap(this.handlerMap));
    }

    @Override
    public <T extends EObject> void registerAsynchronousConstraintChecker(IConstraintChecker<T> checker, Class<T> modelElementClass, String checkerName) {
        if (checker == null) {
            return;
        }
        List<IConstraintChecker<EObject>> checkers = this.asynchronousConstraintCheckers.get(modelElementClass);
        if (checkers == null) {
            checkers = new ArrayList<IConstraintChecker<EObject>>();
            this.asynchronousConstraintCheckers.put(modelElementClass, checkers);
        }
        checkers.add(checker);
        this.asynchronousCheckIdentifiers.put(checker, checkerName);
    }
}

