/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.internal.storage.eclipse.AutoUndoCommandStack;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

final class DummyTopLevelElement
implements ITopLevelElement,
CommandStackListener {
    private final EObject root;
    private final TransactionalEditingDomain editingDomain;
    private final AutoUndoCommandStack transactionalCommandStack;
    private final List<CommandStackListener> listeners = new LinkedList<CommandStackListener>();

    public DummyTopLevelElement(EObject root) {
        Assert.isNotNull((Object)root);
        this.root = root;
        this.editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        Resource res = this.editingDomain.getResourceSet().createResource(URI.createURI((String)"dummy://dummy"));
        this.transactionalCommandStack = new AutoUndoCommandStack(this.editingDomain);
        this.transactionalCommandStack.addCommandStackListener(this);
        this.runAsNonDirtyingCommand(() -> {
            boolean bl = res.getContents().add((Object)root);
        });
    }

    @Override
    public EObject getRootModelElement() {
        return this.root;
    }

    @Override
    public void runAsCommand(final Runnable runnable) {
        this.transactionalCommandStack.execute((Command)new AbstractCommand(){

            public boolean canExecute() {
                return true;
            }

            public void execute() {
                runnable.run();
            }

            public void redo() {
            }
        });
    }

    @Override
    public void runAsNonDirtyingCommand(final Runnable runnable) {
        try {
            this.transactionalCommandStack.executeNonDirtyingNonUndoing((Command)new AbstractCommand(){

                public void execute() {
                    runnable.run();
                }

                public boolean canExecute() {
                    return true;
                }

                public void redo() {
                }

                public boolean canUndo() {
                    return false;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggingUtils.error(ToolingKernelActivator.getDefault(), "Problem with synchronizing the model!", e);
        }
    }

    @Override
    public void addCommandStackListener(CommandStackListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeCommandStackListener(CommandStackListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean canUndo() {
        return this.transactionalCommandStack.canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.transactionalCommandStack.canRedo();
    }

    @Override
    public void undo() {
        this.transactionalCommandStack.undo();
    }

    @Override
    public void redo() {
        this.transactionalCommandStack.redo();
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public String getSaveableName() {
        return "Dummy";
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public String getId(EObject modelElement) {
        if (modelElement instanceof IIdLabeled) {
            return String.valueOf(((IIdLabeled)modelElement).getId());
        }
        return null;
    }

    @Override
    public void prepareIDs(EObject modelElement) {
        if (!(modelElement instanceof IIdLabeled)) {
            return;
        }
        int id = Integer.MIN_VALUE;
        TreeIterator iter = this.getRootModelElement().eAllContents();
        while (iter.hasNext()) {
            EObject o = (EObject)iter.next();
            if (!(o instanceof IIdLabeled)) continue;
            id = Math.max(id, ((IIdLabeled)o).getId());
        }
        ((IIdLabeled)modelElement).setId(id + 1);
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public ResourceSet getResourceSet() {
        return null;
    }

    public void commandStackChanged(EventObject event) {
        EventObject eo = new EventObject(this);
        for (CommandStackListener l : this.listeners) {
            l.commandStackChanged(eo);
        }
    }
}

