/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.IElementCompositor;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.introspection.items.ElementCompositorKISSDetailsItem;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.service.base.EObjectAwareServiceBase;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public final class ElementCompositorService
extends EObjectAwareServiceBase<IElementCompositor<EObject>>
implements IElementCompositorService,
IIntrospectiveKernelService {
    private static final ElementCompositorService INSTANCE = new ElementCompositorService();
    private static final String EXTENSION_POINT_NAME = "org.fortiss.tooling.kernel.modelElementCompositor";
    private static final String CONFIGURATION_ELEMENT_NAME = "modelElementCompositor";
    private static final String HANDLER_CLASS_ATTRIBUTE_NAME = "compositor";

    public static ElementCompositorService getInstance() {
        return INSTANCE;
    }

    @Override
    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService(this);
    }

    @Override
    public void registerElementCompositor(IElementCompositor<EObject> compositor, Class<?> modelElementClass) {
        this.addHandler(modelElementClass, compositor);
    }

    @Override
    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThis service allows the registration of element compositors.\nElement compositors are responsible for adding a model element as the child of another model element (e.g. a sub-component \nis added to a parent component). Most often contextual data (e.g. the mouse pointer position in a diagram) is used \nto add specific model values during the composition procedure.\nElement composition is centralized with this service, since most often multiple UI gestures \ncan result in the same model element composition (drag and drop vs. context menu vs. keyboard shortcut)\n\nThe service extension point is 'org.fortiss.tooling.kernel.modelElementCompositor'.";
    }

    @Override
    public boolean canCompose(EObject container, EObject element, IElementCompositionContext context) {
        return this.findWorkingCompositor(container, element, context, false) != null;
    }

    @Override
    public boolean compose(EObject container, EObject element, IElementCompositionContext context) {
        IElementCompositor<EObject> compositor = this.findWorkingCompositor(container, element, context, false);
        if (compositor == null) {
            LoggingUtils.error(ToolingKernelActivator.getDefault(), String.format("Cannot find compositor for container %s and element %s", container.getClass(), element.getClass()));
            return false;
        }
        IPersistencyService.getInstance().getTopLevelElementFor(container).prepareIDs(element);
        boolean rval = compositor.compose(container, element, context);
        return rval;
    }

    @Override
    public boolean canComposePrototype(Class<? extends EObject> containerClass, Prototype prototype) {
        List list = this.getRegisteredHandlers(containerClass);
        if (list == null) {
            return false;
        }
        for (IElementCompositor compositor : list) {
            if (!compositor.canComposePrototype(prototype)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDecompose(EObject contained) {
        return this.findWorkingCompositor(contained.eContainer(), contained, null, true) != null;
    }

    @Override
    public boolean decompose(EObject contained) {
        return this.findWorkingCompositor(contained.eContainer(), contained, null, true).decompose(contained);
    }

    private IElementCompositor<EObject> findWorkingCompositor(EObject container, EObject contained, IElementCompositionContext context, boolean decompose) {
        if (container == null) {
            return null;
        }
        List list = this.getRegisteredHandlers(container.getClass());
        if (list == null) {
            return null;
        }
        for (IElementCompositor compositor : list) {
            if (!decompose && compositor.canCompose(container, contained, context)) {
                return compositor;
            }
            if (!decompose || !compositor.canDecompose(contained)) continue;
            return compositor;
        }
        return null;
    }

    @Override
    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    @Override
    protected String getConfigurationElementName() {
        return CONFIGURATION_ELEMENT_NAME;
    }

    @Override
    protected String getHandlerClassAttribute() {
        return HANDLER_CLASS_ATTRIBUTE_NAME;
    }

    @Override
    public String getIntrospectionLabel() {
        return "Element Compositor Service";
    }

    public List<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return new ElementCompositorKISSDetailsItem(this.handlerMap);
    }
}

