/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal;

import java.util.List;
import org.fortiss.tooling.kernel.extension.ILogMessageHandler;
import org.fortiss.tooling.kernel.extension.data.ILogMessageContext;
import org.fortiss.tooling.kernel.extension.data.LogMessage;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.ILoggingService;
import org.fortiss.tooling.kernel.service.base.ObjectAwareServiceBase;

public class LoggingService
extends ObjectAwareServiceBase<ILogMessageHandler<LogMessage>>
implements ILoggingService {
    private static final LoggingService INSTANCE = new LoggingService();
    private static final String EXTENSION_POINT_NAME = "org.fortiss.tooling.kernel.uiMessageHandler";
    private static final String CONFIGURATION_ELEMENT_NAME = "uiMessageHandler";
    private static final String ATTRIBUTE_NAME = "handler";

    public static LoggingService getInstance() {
        return INSTANCE;
    }

    @Override
    public void initializeService() {
        super.initializeService();
    }

    @Override
    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService(this);
    }

    @Override
    public <LM extends LogMessage> void registerLogMessageHandler(ILogMessageHandler<LM> handler, Class<LM> logMessageClass) {
        this.addHandler(logMessageClass, handler);
    }

    @Override
    public String getIntrospectionDescription() {
        return "This service allows the registration of logging message handlers.";
    }

    @Override
    public String getIntrospectionLabel() {
        return "Logging Service";
    }

    @Override
    public void processMessage(LogMessage message, ILogMessageContext context) {
        List handlerList = this.getRegisteredHandlers(message.getClass());
        for (ILogMessageHandler handler : handlerList) {
            handler.showMessage(message, context);
        }
    }

    @Override
    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    @Override
    protected String getConfigurationElementName() {
        return CONFIGURATION_ELEMENT_NAME;
    }

    @Override
    protected String getHandlerClassAttribute() {
        return ATTRIBUTE_NAME;
    }
}

