/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.IMigrationProvider;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.introspection.items.MigrationKISSDetailsItem;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.IMigrationService;
import org.fortiss.tooling.kernel.service.base.ObjectAwareServiceBase;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class MigrationService
extends ObjectAwareServiceBase<IMigrationProvider>
implements IMigrationService,
IIntrospectiveKernelService {
    private static final MigrationService INSTANCE = new MigrationService();
    private static final String EXTENSION_POINT_NAME = "org.fortiss.tooling.kernel.migrationProvider";
    private static final String CONFIGURATION_ELEMENT_NAME = "migrationProvider";
    private static final String ATTRIBUTE_NAME = "migrationProvider";

    public static MigrationService getInstance() {
        return INSTANCE;
    }

    @Override
    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService(this);
    }

    @Override
    public void registerMigrationProvider(IMigrationProvider provider, Class<?> modelElementClass) {
        this.addHandler(modelElementClass, provider);
    }

    @Override
    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThis service allows the registration of migrator classes, which perform the\nmigration of models should the meta-model of the modeling language change.\n\nThe service extension point is 'org.fortiss.tooling.kernel.migrationProvider'.";
    }

    @Override
    public boolean needMigration(ITopLevelElement input, Map<EObject, AnyType> unknownFeatures) {
        for (IMigrationProvider provider : this.getProviders(input)) {
            if (!provider.needMigration(input, unknownFeatures)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void migrate(final ITopLevelElement input, final Map<EObject, AnyType> unknownFeatures) {
        input.runAsNonDirtyingCommand(new Runnable(){

            @Override
            public void run() {
                HashMap<EObject, AnyType> migratedFeatures = new HashMap<EObject, AnyType>();
                for (IMigrationProvider provider : MigrationService.this.getProviders(input)) {
                    if (!provider.needMigration(input, unknownFeatures)) continue;
                    migratedFeatures.putAll(provider.migrate(input, unknownFeatures));
                }
                for (IMigrationProvider provider : MigrationService.this.getProviders(input)) {
                    if (!provider.needMigration(input, unknownFeatures)) continue;
                    LoggingUtils.error(ToolingKernelActivator.getDefault(), "Migrating " + input.getSaveableName() + " failed: A need for migration is indicated although the migration was already performed. Please fix the migrator " + provider.getClass().getSimpleName() + " or the model.");
                }
                unknownFeatures.entrySet().removeAll(migratedFeatures.entrySet());
                if (!unknownFeatures.isEmpty()) {
                    Stream<AnyType> anyTypes = unknownFeatures.values().stream().map(v -> v.getMixed()).flatMap(f -> f.stream()).map(e -> e.getValue()).filter(AnyType.class::isInstance).map(AnyType.class::cast);
                    String removedTypes = anyTypes.map(a -> a.eClass().getName()).collect(Collectors.toSet()).stream().collect(Collectors.joining(", "));
                    LoggingUtils.warning(ToolingKernelActivator.getDefault(), input.getSaveableName() + " contains one or more feature(s) of the following unkown types that will be deleted: " + removedTypes + ".");
                    unknownFeatures.clear();
                }
            }
        });
        try {
            input.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            LoggingUtils.error(ToolingKernelActivator.getDefault(), "Error during migration of model!", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private List<IMigrationProvider> getProviders(ITopLevelElement input) {
        ArrayList<IMigrationProvider> providers = new ArrayList<IMigrationProvider>();
        EObject migElement = input.getRootModelElement();
        for (Map.Entry migEntry : this.handlerMap.entrySet()) {
            if (EcoreUtils.getFirstChildWithType(migElement, (Class)migEntry.getKey()) == null) continue;
            providers.addAll((Collection)migEntry.getValue());
        }
        return providers;
    }

    @Override
    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    @Override
    protected String getConfigurationElementName() {
        return "migrationProvider";
    }

    @Override
    protected String getHandlerClassAttribute() {
        return "migrationProvider";
    }

    @Override
    public String getIntrospectionLabel() {
        return "Migration Service";
    }

    public List<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return new MigrationKISSDetailsItem(this.handlerMap);
    }
}

