/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.IStorageProvider;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.extension.data.ModelStorageError;
import org.fortiss.tooling.kernel.internal.DummyTopLevelElement;
import org.fortiss.tooling.kernel.internal.storage.eclipse.EclipseResourceStorageService;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.introspection.items.PersistencyKISSDetailsItem;
import org.fortiss.tooling.kernel.model.ILibrary;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.service.ITutorialService;
import org.fortiss.tooling.kernel.service.listener.IPersistencyServiceListener;
import org.fortiss.tooling.kernel.utils.ExtensionPointUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.osgi.framework.Bundle;

public class PersistencyService
implements IPersistencyService,
IIntrospectiveKernelService {
    private static final PersistencyService INSTANCE = new PersistencyService();
    private static final String EXTENSION_POINT_NAME = "org.fortiss.tooling.kernel.modelStorageProvider";
    private static final String CONFIGURATION_ELEMENT_NAME = "modelStorageProvider";
    private final List<IStorageProvider> storageProviderList = new ArrayList<IStorageProvider>();
    private final List<ITopLevelElement> elementCache = new LinkedList<ITopLevelElement>();
    private Map<EObject, ITopLevelElement> dummyCache = null;
    private final Map<ITopLevelElement, IStorageProvider> storageProviderCache = new HashMap<ITopLevelElement, IStorageProvider>();
    private final List<IPersistencyServiceListener> listeners = new ArrayList<IPersistencyServiceListener>();
    private ITutorialService tutorialService;

    public static PersistencyService getInstance() {
        return INSTANCE;
    }

    public void initializeService() {
        this.setupStorageProviders();
        for (IStorageProvider p : this.storageProviderList) {
            if (!(p instanceof EclipseResourceStorageService)) continue;
            EclipseResourceStorageService ersp = (EclipseResourceStorageService)p;
            ersp.initializeService();
        }
        this.initializeTopLevelElementContexts();
    }

    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService(this);
        this.tutorialService = ITutorialService.getInstance();
    }

    @Override
    public void registerModelStorageProvider(IStorageProvider provider) {
        this.storageProviderList.add(provider);
        for (ITopLevelElement context : provider.getTopLevelElements()) {
            this.elementCache.add(context);
            this.storageProviderCache.put(context, provider);
            this.notifyListenersAboutLoad(context);
        }
    }

    @Override
    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThis service manages the storage of models using a registered persistency mechanism most commonly the local file system storage.\nIt provides access to top-level elements, which are the entry point to each models command stack.\nIt also provides a mechanism to add arbitrary EObjects as dummy top-level elements without requiring them \nto be backed up by any storage solution (i.e. memory only model). With this the kernel can act as if some model was persisted.\nThe latter feature is usually used by tests.\n\nThe service extension point is 'org.fortiss.tooling.kernel.modelStorageProvider'.";
    }

    public synchronized UnmodifiableList<ITopLevelElement> getTopLevelElements() {
        if (this.tutorialService != null && this.tutorialService.isTutorialActive()) {
            EObject activeRootElement = this.tutorialService.getActiveTutorial().getRootElement();
            return CollectionUtils.asUnmodifiable(this.elementCache.stream().filter(t -> t.getRootModelElement() == activeRootElement).collect(Collectors.toList()));
        }
        Stream<ITopLevelElement> noDummy = this.elementCache.stream().filter(elt -> !(elt instanceof DummyTopLevelElement));
        return CollectionUtils.asUnmodifiable(noDummy.collect(Collectors.toList()));
    }

    @Override
    public synchronized boolean isTopLevelElement(EObject element) {
        for (ITopLevelElement context : this.elementCache) {
            if (context.getRootModelElement() != element) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isDirty() {
        for (ITopLevelElement context : this.elementCache) {
            if (!context.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void doSave(IProgressMonitor monitor) {
        for (ITopLevelElement context : this.elementCache) {
            if (!context.isDirty()) continue;
            try {
                context.doSave(monitor);
            }
            catch (CoreException e) {
                LoggingUtils.error(ToolingKernelActivator.getDefault(), "Error during save operation.", e);
            }
            catch (IOException e) {
                LoggingUtils.error(ToolingKernelActivator.getDefault(), "Error during save operation.", e);
            }
        }
    }

    @Override
    public synchronized void refreshTopLevelElements(IStorageProvider provider) {
        if (provider == null) {
            return;
        }
        List<ITopLevelElement> providedElements = provider.getTopLevelElements();
        LinkedList<ITopLevelElement> removedCacheElements = new LinkedList<ITopLevelElement>();
        for (ITopLevelElement top : this.elementCache) {
            if (provider != this.storageProviderCache.get(top) || providedElements.contains(top)) continue;
            removedCacheElements.add(top);
        }
        for (ITopLevelElement top : providedElements) {
            if (this.elementCache.contains(top)) continue;
            this.elementCache.add(top);
            this.storageProviderCache.put(top, provider);
            this.notifyListenersAboutAdd(top);
        }
        for (ITopLevelElement top : removedCacheElements) {
            this.elementCache.remove(top);
            this.storageProviderCache.remove(top);
            this.notifyListenersAboutRemove(top);
        }
    }

    @Override
    public synchronized void addTopLevelElementListener(IPersistencyServiceListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeTopLevelElementListener(IPersistencyServiceListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized void notifyListenersAboutLoad(ITopLevelElement top) {
        if (top.getRootModelElement() instanceof ILibrary) {
            return;
        }
        for (IPersistencyServiceListener listener : new ArrayList<IPersistencyServiceListener>(this.listeners)) {
            listener.topLevelElementLoaded(top);
        }
    }

    private synchronized void notifyListenersAboutAdd(ITopLevelElement top) {
        if (top.getRootModelElement() instanceof ILibrary) {
            return;
        }
        for (IPersistencyServiceListener listener : new ArrayList<IPersistencyServiceListener>(this.listeners)) {
            listener.topLevelElementAdded(top);
        }
    }

    private synchronized void notifyListenersAboutRemove(ITopLevelElement top) {
        if (top.getRootModelElement() instanceof ILibrary) {
            return;
        }
        for (IPersistencyServiceListener listener : new ArrayList<IPersistencyServiceListener>(this.listeners)) {
            listener.topLevelElementRemoved(top);
        }
    }

    @Override
    public void notifyTopLevelElementChanged(final ITopLevelElement top) {
        if (top.getRootModelElement() instanceof ILibrary) {
            return;
        }
        new WorkspaceJob("Notify TopLevelElement Changed"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) {
                PersistencyService persistencyService = PersistencyService.this;
                synchronized (persistencyService) {
                    for (IPersistencyServiceListener listener : PersistencyService.this.listeners) {
                        listener.topLevelElementContentChanged(top);
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    @Override
    public synchronized ITopLevelElement getTopLevelElementFor(EObject modelElement) {
        while (modelElement != null) {
            for (ITopLevelElement context : this.elementCache) {
                if (context.getRootModelElement() != modelElement) continue;
                return context;
            }
            modelElement = modelElement.eContainer();
        }
        return null;
    }

    private void setupStorageProviders() {
        for (IConfigurationElement ce : ExtensionPointUtils.getConfigurationElements(EXTENSION_POINT_NAME, CONFIGURATION_ELEMENT_NAME)) {
            Bundle bundle = ExtensionPointUtils.getBundle(ce);
            try {
                Class<?> handlerClass = ExtensionPointUtils.loadClass(ce.getAttribute("provider"), bundle);
                IStorageProvider provider = (IStorageProvider)handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.storageProviderList.add(provider);
            }
            catch (Exception e) {
                LoggingUtils.error(ToolingKernelActivator.getDefault(), e.getMessage(), e);
            }
        }
    }

    private void initializeTopLevelElementContexts() {
        for (IStorageProvider provider : this.storageProviderList) {
            for (ITopLevelElement context : provider.getTopLevelElements()) {
                this.elementCache.add(context);
                this.storageProviderCache.put(context, provider);
            }
        }
    }

    @Override
    public ITopLevelElement addDummyEObjectAsTopLevelElement(EObject dummyRoot) {
        if (this.dummyCache == null) {
            this.dummyCache = new HashMap<EObject, ITopLevelElement>();
        }
        DummyTopLevelElement dummy = new DummyTopLevelElement(dummyRoot);
        this.dummyCache.put(dummyRoot, dummy);
        this.elementCache.add(dummy);
        this.notifyListenersAboutAdd(dummy);
        return dummy;
    }

    @Override
    public void removeDummyTopLevelElement(EObject dummy) {
        if (this.dummyCache == null || !this.dummyCache.containsKey(dummy)) {
            return;
        }
        ITopLevelElement top = this.dummyCache.get(dummy);
        this.elementCache.remove(top);
        this.dummyCache.remove(dummy);
        this.notifyListenersAboutRemove(top);
    }

    @Override
    public List<ModelStorageError> getAllStorageErrors() {
        ArrayList<ModelStorageError> errors = new ArrayList<ModelStorageError>();
        for (IStorageProvider provider : this.storageProviderList) {
            errors.addAll(provider.getStorageErrors());
        }
        return errors;
    }

    @Override
    public String getIntrospectionLabel() {
        return "Persistency Service";
    }

    public List<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return new PersistencyKISSDetailsItem(Collections.unmodifiableList(this.storageProviderList));
    }
}

