/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.IPrototypeProvider;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.extension.data.PrototypeCategory;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.introspection.items.PrototypeKISSDetailsItem;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.IPrototypeService;
import org.fortiss.tooling.kernel.service.ITutorialService;
import org.fortiss.tooling.kernel.utils.ExtensionPointUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.osgi.framework.Bundle;

public class PrototypeService
implements IPrototypeService,
IIntrospectiveKernelService {
    private static final PrototypeService INSTANCE = new PrototypeService();
    private static final String EXTENSION_POINT_NAME = "org.fortiss.tooling.kernel.modelPrototypeProvider";
    private static final String CONFIGURATION_ELEMENT_NAME = "modelPrototypeProvider";
    private final List<IPrototypeProvider> prototypeProviderList = new ArrayList<IPrototypeProvider>();
    private ITutorialService tutorialService;
    private Map<Class<? extends EObject>, List<Prototype>> composablePrototypesCache = new HashMap<Class<? extends EObject>, List<Prototype>>();

    public static PrototypeService getInstance() {
        return INSTANCE;
    }

    public void initializeService() {
        this.setupPrototypes();
    }

    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService(this);
        this.tutorialService = ITutorialService.getInstance();
    }

    @Override
    public void registerPrototypeProvider(IPrototypeProvider provider) {
        this.prototypeProviderList.add(provider);
    }

    public void updatePrototypes() {
        this.composablePrototypesCache.clear();
        UnmodifiableList<IPrototypeProvider> providerList = this.getPrototypeProviders();
        for (IPrototypeProvider provider : providerList) {
            provider.refreshCurrentPrototypes();
        }
    }

    @Override
    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThis service manages the model element prototypes.\nTo understand what a prototype is consider what happens when you drag and drop an element from the palette:\nwhat happens internally is that we copy a reference element from the palette into the project.\nThis reference element is what we call a \"prototype\"\nUsually model elements are composed of a couple of EObjects and have their attributes set to some predefined values.\nEach part of the modeling language(s) can register prototype provider classes, which then provide the model elements.\n\nThe service extension point is 'org.fortiss.tooling.kernel.modelPrototypeProvider'.";
    }

    private void setupPrototypes() {
        for (IConfigurationElement ce : ExtensionPointUtils.getConfigurationElements(EXTENSION_POINT_NAME, CONFIGURATION_ELEMENT_NAME)) {
            Bundle bundle = ExtensionPointUtils.getBundle(ce);
            try {
                Class<?> handlerClass = ExtensionPointUtils.loadClass(ce.getAttribute("provider"), bundle);
                IPrototypeProvider provider = (IPrototypeProvider)handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.prototypeProviderList.add(provider);
            }
            catch (Exception ex) {
                LoggingUtils.error(ToolingKernelActivator.getDefault(), ex.getMessage(), ex);
            }
        }
    }

    @Override
    public UnmodifiableList<IPrototypeProvider> getPrototypeProviders() {
        return CollectionUtils.asUnmodifiable(this.prototypeProviderList);
    }

    @Override
    public UnmodifiableList<Prototype> getAllPrototypes() {
        if (this.tutorialService.isTutorialActive()) {
            return CollectionUtils.asUnmodifiable(this.getPrototypes(false).stream().filter(proto -> this.tutorialService.prototypeActive((Prototype)proto)).collect(Collectors.toList()));
        }
        return CollectionUtils.asUnmodifiable(this.getPrototypes(false));
    }

    @Override
    public UnmodifiableList<Prototype> getPrimaryPrototypes() {
        if (this.tutorialService.isTutorialActive()) {
            return CollectionUtils.asUnmodifiable(this.getPrototypes(true).stream().filter(proto -> this.tutorialService.prototypeActive((Prototype)proto)).collect(Collectors.toList()));
        }
        return CollectionUtils.asUnmodifiable(this.getPrototypes(true));
    }

    private List<Prototype> getPrototypes(boolean primaryOnly) {
        ArrayList<Prototype> result = new ArrayList<Prototype>();
        for (IPrototypeProvider provider : this.prototypeProviderList) {
            for (Prototype p : provider.getPrototypes()) {
                if (primaryOnly && !p.isPrimary()) continue;
                result.add(p);
            }
        }
        return result;
    }

    @Override
    public String getUniquePrototypeID(Prototype prototype) {
        for (IPrototypeProvider prov : this.prototypeProviderList) {
            String uid = prov.getUniqueID(prototype);
            if (uid == null) continue;
            return uid;
        }
        return null;
    }

    @Override
    public Prototype getPrototypeByUniqueID(String id) {
        for (IPrototypeProvider prov : this.prototypeProviderList) {
            Prototype proto = prov.getPrototypeByID(id);
            if (proto == null) continue;
            return proto;
        }
        return null;
    }

    @Override
    public List<Prototype> getComposablePrototypes(Class<? extends EObject> modelElementType) {
        List<Prototype> composablePrototypes = this.composablePrototypesCache.get(modelElementType);
        if (composablePrototypes != null) {
            return composablePrototypes;
        }
        IElementCompositorService ecs = IElementCompositorService.getInstance();
        composablePrototypes = new LinkedList<Prototype>();
        for (Prototype prototype : this.getAllPrototypes()) {
            if (!ecs.canComposePrototype(modelElementType, prototype)) continue;
            composablePrototypes.add(prototype);
        }
        composablePrototypes = Collections.unmodifiableList(composablePrototypes);
        this.composablePrototypesCache.put(modelElementType, composablePrototypes);
        return composablePrototypes;
    }

    @Override
    public List<PrototypeCategory> getAllTopLevelPrototypesCategories() {
        IdentityHashSet categories = new IdentityHashSet();
        for (IPrototypeProvider provider : this.prototypeProviderList) {
            for (PrototypeCategory currentCategory : provider.getCategories()) {
                if (currentCategory.getParentCategory() != null) continue;
                categories.add(currentCategory);
            }
        }
        List<PrototypeCategory> result = categories.stream().sorted(new PrototypeCategory.PrototypeCategoryComparator()).collect(Collectors.toList());
        Collections.reverse(result);
        return result;
    }

    @Override
    public String getIntrospectionLabel() {
        return "Prototype Service";
    }

    public List<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return new PrototypeKISSDetailsItem(this.prototypeProviderList);
    }
}

