/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.fortiss.tooling.kernel.extension.ITransformationProvider;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.data.TransformationProviderChain;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.introspection.items.TransformationKISSDetailsItem;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.ITransformationService;
import org.fortiss.tooling.kernel.service.base.ObjectAware2ServiceBase;

public class TransformationService
extends ObjectAware2ServiceBase<ITransformationProvider>
implements ITransformationService,
IIntrospectiveKernelService {
    private static final TransformationService INSTANCE = new TransformationService();
    private static final String EXTENSION_POINT_NAME = "org.fortiss.tooling.kernel.transformationProvider";
    private static final String CONFIGURATION_ELEMENT_NAME = "transformationProvider";
    private static final String ATTRIBUTE_NAME = "transformationProvider";

    public static TransformationService getInstance() {
        return INSTANCE;
    }

    @Override
    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService(this);
    }

    @Override
    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThis service manages registration and execution of transformations.\nThis service can be asked to provide a transformation or a chain of transformations, which \ntransform an object of arbitrary class A into an object of another arbitrary class B.\nTherefore transformations are not restricted to EObject instances, but extend to all Java classes.\nWhen a specific transformation is required the service can also provide a chain of transformations\nbased on the providers available to it.\n\nThe service extension point is 'org.fortiss.tooling.kernel.transformationProvider'.";
    }

    @Override
    public void registerTransformationProvider(ITransformationProvider provider, Class<?> sourceClass, Class<?> targetClass) {
        this.addHandler(sourceClass, targetClass, provider);
    }

    private ITransformationProvider findWorkingTransformationProvider(Object source, Class<?> targetClass, ITransformationContext context) {
        List list = this.getRegisteredHandlers(source.getClass(), targetClass);
        if (list == null) {
            return null;
        }
        for (ITransformationProvider provider : list) {
            if (!provider.canTransform(source, context)) continue;
            return provider;
        }
        return null;
    }

    @Override
    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    @Override
    protected String getConfigurationElementName() {
        return "transformationProvider";
    }

    @Override
    protected String getHandlerClassAttribute() {
        return "transformationProvider";
    }

    @Override
    public boolean canTransform(Object source, Class<?> targetClass, ITransformationContext context) {
        return this.findWorkingTransformationProvider(source, targetClass, context) != null;
    }

    @Override
    public Object transform(Object source, Class<?> targetClass, ITransformationContext context) throws TransformationFailedException {
        return this.findWorkingTransformationProvider(source, targetClass, context).transform(source, context);
    }

    @Override
    public List<TransformationProviderChain> getTransformationProviderChain(Class<?> sourceClass, Class<?> targetClass, ITransformationContext context) {
        LinkedList<TransformationProviderChain> results = new LinkedList<TransformationProviderChain>();
        LinkedList<ITransformationProvider> currentChain = new LinkedList<ITransformationProvider>();
        HashSet seenTargets = new HashSet();
        seenTargets.add(sourceClass);
        this.findTransformationChains(sourceClass, targetClass, results, currentChain, seenTargets, context);
        return results;
    }

    private void findTransformationChains(Class<?> sourceClass, Class<?> targetClass, List<TransformationProviderChain> results, List<ITransformationProvider> currentChain, Set<Class<?>> seenTargets, ITransformationContext context) {
        if (!currentChain.isEmpty() && targetClass.isAssignableFrom(currentChain.get(currentChain.size() - 1).getTargetClass())) {
            results.add(new TransformationProviderChain(currentChain));
            return;
        }
        if (seenTargets.contains(targetClass)) {
            return;
        }
        Map providerMap = (Map)ReflectionUtils.performNearestClassLookup(sourceClass, (Map)this.handlersBySource);
        if (providerMap == null || providerMap.isEmpty()) {
            return;
        }
        for (Class key : providerMap.keySet()) {
            List providerList = (List)providerMap.get(key);
            for (ITransformationProvider provider : providerList) {
                if (!provider.canHandleChainTransformation(sourceClass, context)) continue;
                currentChain.add(provider);
                seenTargets.add(provider.getTargetClass());
                this.findTransformationChains(provider.getTargetClass(), targetClass, results, currentChain, seenTargets, context);
                currentChain.remove(provider);
                seenTargets.remove(provider.getTargetClass());
            }
        }
    }

    @Override
    public String getIntrospectionLabel() {
        return "Transformation Service";
    }

    public List<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return new TransformationKISSDetailsItem(this.handlersBySource);
    }
}

