/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.ITutorialProvider;
import org.fortiss.tooling.kernel.extension.ITutorialWhitelistProvider;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.extension.data.TutorialAtomicStep;
import org.fortiss.tooling.kernel.extension.data.TutorialCompositeStep;
import org.fortiss.tooling.kernel.extension.data.TutorialStepBase;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.service.ITutorialService;
import org.fortiss.tooling.kernel.service.listener.ITutorialServiceListener;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public final class TutorialService
implements ITutorialService,
CommandStackListener,
IIntrospectiveKernelService {
    private static final TutorialService INSTANCE = new TutorialService();
    private Map<String, Map<String, Class<? extends ITutorialProvider>>> allTutorials = new HashMap<String, Map<String, Class<? extends ITutorialProvider>>>();
    private Collection<ITutorialServiceListener> listeners = new LinkedList<ITutorialServiceListener>();
    private List<TutorialAtomicStep> atomicStepList = new ArrayList<TutorialAtomicStep>();
    private TutorialAtomicStep finalAtomicStep;
    private ITutorialProvider activeTutorial = null;
    private TutorialAtomicStep activeStep = null;
    private ITopLevelElement activeTopElement = null;
    private IPersistencyService persistencyService;
    private ICommandStackService commandStackService;

    public static TutorialService getInstance() {
        return INSTANCE;
    }

    public void initializeService() {
    }

    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService(this);
    }

    @Override
    public String getIntrospectionLabel() {
        return "Tutorial Service";
    }

    @Override
    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThis service manages tutorials, which can be registered via it.\nThis service can be asked to start and to stop tutorials. It also provides information \nabout the currently active tutorial and the current tutorial step.\nIt notifies interested listeners about progress and changes to the current step.\nThis service provides access to prototypes constrained by the current step.\nThe other kernel services interact with the tutorial service when a tutorial is active\nin order to provide the selective look-and-feel of the tutorial mode.";
    }

    @Override
    public boolean isTutorialActive() {
        return this.activeTutorial != null;
    }

    @Override
    public ITutorialProvider getActiveTutorial() {
        return this.activeTutorial;
    }

    @Override
    public TutorialStepBase getActiveTutorialStep() {
        return this.activeStep;
    }

    @Override
    public Map<String, Class<? extends ITutorialProvider>> getAllTutorialProviders(String category) {
        if (!this.allTutorials.containsKey(category)) {
            return Collections.emptyMap();
        }
        return CollectionUtils.asUnmodifiable(this.allTutorials.get(category));
    }

    @Override
    public Collection<String> getProviderCategories() {
        return CollectionUtils.asUnmodifiable(this.allTutorials.keySet());
    }

    @Override
    public void registerTutorialProvider(Class<? extends ITutorialProvider> provider, String displayName, String category) {
        Map<String, Class<? extends ITutorialProvider>> categoryMap;
        if (category == null) {
            category = "";
        }
        if ((categoryMap = this.allTutorials.get(category)) == null) {
            categoryMap = new HashMap<String, Class<? extends ITutorialProvider>>();
            this.allTutorials.put(category, categoryMap);
        }
        categoryMap.put(displayName, provider);
    }

    @Override
    public void startTutorial(Class<? extends ITutorialProvider> provider) {
        this.persistencyService = IPersistencyService.getInstance();
        this.commandStackService = ICommandStackService.getInstance();
        try {
            this.activeTutorial = provider.newInstance();
            List<TutorialStepBase> rootSteps = this.activeTutorial.getDefinition().getSteps();
            for (TutorialStepBase step : rootSteps) {
                this.collectAtomicSteps(step);
            }
            this.activeStep = this.atomicStepList.get(0);
            this.finalAtomicStep = this.atomicStepList.get(this.atomicStepList.size() - 1);
            EObject root = this.activeTutorial.getRootElement();
            this.activeTopElement = this.persistencyService.addDummyEObjectAsTopLevelElement(root);
            this.commandStackService.addCommandStackListener(this.activeTopElement, this);
            this.fireTutorialStarted();
        }
        catch (InstantiationException e) {
            LoggingUtils.error(ToolingKernelActivator.getDefault(), e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            LoggingUtils.error(ToolingKernelActivator.getDefault(), e.getMessage(), e);
        }
    }

    private void collectAtomicSteps(TutorialStepBase step) {
        if (step instanceof TutorialAtomicStep) {
            this.atomicStepList.add((TutorialAtomicStep)step);
        } else if (step instanceof TutorialCompositeStep) {
            TutorialCompositeStep tsc = (TutorialCompositeStep)step;
            for (TutorialStepBase s : tsc.getSteps()) {
                this.collectAtomicSteps(s);
            }
        }
    }

    @Override
    public void stopTutorial() {
        this.fireTutorialStopped();
        this.commandStackService.removeCommandStackListener(this.activeTopElement, this);
        this.commandStackService = null;
        this.persistencyService.removeDummyTopLevelElement(this.activeTutorial.getRootElement());
        this.persistencyService = null;
        this.activeTopElement = null;
        this.atomicStepList.clear();
        this.activeStep = null;
        this.activeTutorial = null;
    }

    @Override
    public void addTutorialServiceListener(ITutorialServiceListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeTutorialServiceListener(ITutorialServiceListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean prototypeActive(Prototype prototype) {
        TutorialStepBase curStep = this.activeStep;
        while (curStep != null) {
            ITutorialWhitelistProvider p;
            if (curStep instanceof ITutorialWhitelistProvider && (p = (ITutorialWhitelistProvider)((Object)curStep)).prototypeActive(prototype)) {
                return true;
            }
            curStep = curStep.getParent();
        }
        return false;
    }

    @Override
    public boolean isCompletedStep(TutorialStepBase step) {
        if (step instanceof TutorialCompositeStep) {
            TutorialCompositeStep cmp = (TutorialCompositeStep)step;
            TutorialStepBase inner = cmp.getSteps().get(cmp.getSteps().size() - 1);
            return this.isCompletedStep(inner);
        }
        if (step == this.activeStep) {
            return this.activeStep.getCompletionChecker().test(this.activeTutorial.getRootElement());
        }
        return this.isEarlierThanActiveStep(step);
    }

    private boolean isEarlierThanActiveStep(TutorialStepBase step) {
        if (step instanceof TutorialCompositeStep) {
            TutorialCompositeStep cmp = (TutorialCompositeStep)step;
            TutorialStepBase inner = cmp.getSteps().get(cmp.getSteps().size() - 1);
            return this.isEarlierThanActiveStep(inner);
        }
        int current = this.atomicStepList.indexOf(this.activeStep);
        int test = this.atomicStepList.indexOf(step);
        return test < current;
    }

    public void commandStackChanged(EventObject event) {
        TutorialAtomicStep old = this.activeStep;
        this.activeStep = this.finalAtomicStep;
        for (TutorialAtomicStep step : this.atomicStepList) {
            if (step.getCompletionChecker().test(this.activeTutorial.getRootElement())) continue;
            this.activeStep = step;
            break;
        }
        if (this.activeStep != old || this.activeStep == this.finalAtomicStep) {
            this.fireTutorialStepChanged();
        }
    }

    @Override
    public List<TutorialAtomicStep> getAtomicTutorialSteps() {
        return CollectionUtils.asUnmodifiable(this.atomicStepList);
    }

    private void fireTutorialStepChanged() {
        for (ITutorialServiceListener l : this.listeners) {
            l.tutorialStepChanged(this.activeStep);
        }
    }

    private void fireTutorialStarted() {
        for (ITutorialServiceListener l : this.listeners) {
            l.tutorialStarted(this.activeTutorial);
        }
    }

    private void fireTutorialStopped() {
        for (ITutorialServiceListener l : this.listeners) {
            l.tutorialStopped(this.activeTutorial);
        }
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    @Override
    public Collection<IIntrospectionItem> getIntrospectionItems() {
        return null;
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return null;
    }
}

