/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal.storage.eclipse;

import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.transaction.ExceptionHandler;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.fortiss.tooling.kernel.internal.storage.eclipse.EMFTransactionalCommand;
import org.fortiss.tooling.kernel.internal.storage.eclipse.NonDirtyingEMFTransactionalCommand;

public class AutoUndoCommandStack
implements TransactionalCommandStack {
    private final TransactionalEditingDomain editingDomain;
    private final TransactionalCommandStack commandStack;

    public AutoUndoCommandStack(TransactionalEditingDomain editingDomain) {
        this.editingDomain = editingDomain;
        this.commandStack = (TransactionalCommandStack)editingDomain.getCommandStack();
    }

    public void addCommandStackListener(CommandStackListener listener) {
        this.commandStack.addCommandStackListener(listener);
    }

    public boolean canRedo() {
        return this.commandStack.canRedo();
    }

    public boolean canUndo() {
        return this.commandStack.canUndo();
    }

    public void execute(Command command, Map options) throws InterruptedException, RollbackException {
        this.commandStack.execute((Command)new EMFTransactionalCommand(command, this.editingDomain), options);
    }

    public void execute(Command command) {
        this.commandStack.execute((Command)new EMFTransactionalCommand(command, this.editingDomain));
    }

    public void executeNonDirtyingNonUndoing(Command command) throws InterruptedException, RollbackException {
        this.commandStack.execute((Command)new NonDirtyingEMFTransactionalCommand(command, this.editingDomain), Collections.singletonMap("no_undo", Boolean.TRUE));
    }

    public void flush() {
        this.commandStack.flush();
    }

    public ExceptionHandler getExceptionHandler() {
        return this.commandStack.getExceptionHandler();
    }

    public Command getMostRecentCommand() {
        return this.commandStack.getMostRecentCommand();
    }

    public Command getRedoCommand() {
        return this.commandStack.getRedoCommand();
    }

    public Command getUndoCommand() {
        return this.commandStack.getUndoCommand();
    }

    public void redo() {
        this.commandStack.redo();
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        this.commandStack.removeCommandStackListener(listener);
    }

    public void setExceptionHandler(ExceptionHandler handler) {
        this.commandStack.setExceptionHandler(handler);
    }

    public void undo() {
        this.commandStack.undo();
    }
}

