/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal.storage.eclipse;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class EMFTransactionalCommand
implements Command {
    private final Command inner;
    private final RecordingCommand recordingCommand;
    private final InternalTransactionalEditingDomain editingDomain;

    public EMFTransactionalCommand(Command command, TransactionalEditingDomain editingDomain) {
        this.inner = command;
        this.recordingCommand = new RecordingCommand(editingDomain){

            protected void doExecute() {
                EMFTransactionalCommand.this.inner.execute();
            }
        };
        this.editingDomain = (InternalTransactionalEditingDomain)editingDomain;
    }

    public void execute() {
        this.runInTransaction(new Runnable(){

            @Override
            public void run() {
                EMFTransactionalCommand.this.recordingCommand.execute();
            }
        });
    }

    public void redo() {
        this.runInTransaction(new Runnable(){

            @Override
            public void run() {
                EMFTransactionalCommand.this.recordingCommand.redo();
            }
        });
    }

    public void undo() {
        this.runInTransaction(new Runnable(){

            @Override
            public void run() {
                EMFTransactionalCommand.this.recordingCommand.undo();
            }
        });
    }

    private void runInTransaction(Runnable runnable) {
        block14: {
            InternalTransaction tx = null;
            try {
                try {
                    tx = this.editingDomain.startTransaction(false, null);
                    runnable.run();
                }
                catch (InterruptedException e) {
                    LoggingUtils.error(ToolingKernelActivator.getDefault(), "Had unexpected interruption in command execution!", e);
                    if (tx != null) {
                        try {
                            tx.commit();
                        }
                        catch (RollbackException e2) {
                            LoggingUtils.error(ToolingKernelActivator.getDefault(), "Transaction was rolled back!", e2);
                        }
                        break block14;
                    }
                    LoggingUtils.error(ToolingKernelActivator.getDefault(), "Was not able to start transaction!");
                }
            }
            finally {
                if (tx != null) {
                    try {
                        tx.commit();
                    }
                    catch (RollbackException e) {
                        LoggingUtils.error(ToolingKernelActivator.getDefault(), "Transaction was rolled back!", e);
                    }
                } else {
                    LoggingUtils.error(ToolingKernelActivator.getDefault(), "Was not able to start transaction!");
                }
            }
        }
    }

    public boolean canExecute() {
        return this.inner.canExecute();
    }

    public boolean canUndo() {
        return this.recordingCommand.canUndo();
    }

    public Collection<?> getAffectedObjects() {
        return this.inner.getAffectedObjects();
    }

    public String getDescription() {
        return this.inner.getDescription();
    }

    public String getLabel() {
        return this.inner.getLabel();
    }

    public Collection<?> getResult() {
        return this.inner.getResult();
    }

    public Command chain(Command command) {
        if (command == null) {
            return this;
        }
        CompoundCommand result = new CompoundCommand();
        result.append((Command)this);
        result.append(command);
        return result;
    }

    public void dispose() {
        this.inner.dispose();
        this.recordingCommand.dispose();
    }
}

