/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal.storage.eclipse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.IEclipseResourceStorageLocationProvider;
import org.fortiss.tooling.kernel.extension.IStorageProvider;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.extension.data.ModelStorageError;
import org.fortiss.tooling.kernel.internal.storage.eclipse.ModelContext;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.introspection.items.EclipseResourceStorageKISSDetailsItem;
import org.fortiss.tooling.kernel.service.IEclipseResourceStorageService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.IMigrationService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.ExtensionPointUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.osgi.framework.Bundle;

public class EclipseResourceStorageService
implements IEclipseResourceStorageService,
IResourceChangeListener,
IResourceDeltaVisitor,
IStorageProvider,
IIntrospectiveKernelService {
    private static final EclipseResourceStorageService INSTANCE = new EclipseResourceStorageService();
    private static final String LOCATION_PROVIDER_EXTENSION_POINT_NAME = "org.fortiss.tooling.kernel.eclipseResourceStorageLocationProvider";
    private static final String LOCATION_PROVIDER_CONFIGURATION_ELEMENT_NAME = "storageLocationProvider";
    private final List<IEclipseResourceStorageLocationProvider> storageProviderList = new ArrayList<IEclipseResourceStorageLocationProvider>();
    private final Map<IFile, ModelContext> loadedContexts = new HashMap<IFile, ModelContext>();
    private final List<ModelStorageError> errorFiles = new ArrayList<ModelStorageError>();
    private final Map<EObject, ModelContext> rootElementContexts = new IdentityHashMap<EObject, ModelContext>();

    public static EclipseResourceStorageService getInstance() {
        return INSTANCE;
    }

    public void initializeService() {
        this.setupLocationProviders();
    }

    public void startService() {
        this.searchWorkspaceForModels();
        IPersistencyService.getInstance().registerModelStorageProvider(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        IKernelIntrospectionSystemService.getInstance().registerService(this);
    }

    private synchronized void searchWorkspaceForModels() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                this.searchResourceForModels((IContainer)project);
            }
            ++n2;
        }
    }

    private void searchResourceForModels(IContainer container) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFile) {
                    IFile file = (IFile)res;
                    if (this.checkLocationProvider(file)) {
                        this.loadContext(file);
                    }
                } else if (res instanceof IFolder) {
                    this.searchResourceForModels((IContainer)((IFolder)res));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            String msg = "Core Exception while scanning Eclipse workspace";
            LoggingUtils.error(ToolingKernelActivator.getDefault(), msg, e);
        }
    }

    private boolean checkLocationProvider(IFile file) {
        if (file.getFileExtension() == null) {
            return false;
        }
        for (IEclipseResourceStorageLocationProvider provider : this.storageProviderList) {
            if (!provider.isStorageLocation(file)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        EclipseResourceStorageService eclipseResourceStorageService = this;
        synchronized (eclipseResourceStorageService) {
            if (event.getDelta() == null) {
                return;
            }
            try {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                LoggingUtils.error(ToolingKernelActivator.getDefault(), "Kernel Core Exception!", e);
            }
        }
    }

    public boolean visit(IResourceDelta delta) {
        if (delta.getResource() instanceof IFile) {
            this.runWorkspaceChangeJob((IFile)delta.getResource(), delta.getKind());
        }
        return true;
    }

    private void runWorkspaceChangeJob(final IFile file, final int changeKind) {
        WorkspaceJob modelFileChangesJob = new WorkspaceJob("ModelFileChangedJob"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus runInWorkspace(IProgressMonitor monitor) {
                block8: {
                    EclipseResourceStorageService eclipseResourceStorageService = EclipseResourceStorageService.this;
                    synchronized (eclipseResourceStorageService) {
                        block6: {
                            block9: {
                                block7: {
                                    if (!EclipseResourceStorageService.this.checkLocationProvider(file)) break block6;
                                    if (changeKind != 1) break block7;
                                    EclipseResourceStorageService.this.loadContext(file);
                                    break block8;
                                }
                                if (changeKind != 2 || !EclipseResourceStorageService.this.isLoaded(file)) break block9;
                                EclipseResourceStorageService.this.unloadContext(file);
                                break block8;
                            }
                            if (changeKind != 4 || EclipseResourceStorageService.this.isLoaded(file)) break block8;
                            EclipseResourceStorageService.this.loadContext(file);
                            break block8;
                        }
                        if (changeKind == 2) {
                            IPersistencyService ps = IPersistencyService.getInstance();
                            for (ITopLevelElement topLevelElement : ps.getTopLevelElements()) {
                                final ResourceSet resourceSet = topLevelElement.getResourceSet();
                                final ArrayList<Resource> toRemove = new ArrayList<Resource>();
                                for (Resource resource : resourceSet.getResources()) {
                                    String uriString = file.getFullPath().toString();
                                    URI fileURI = URI.createPlatformResourceURI((String)uriString, (boolean)true);
                                    if (!resource.getURI().equals(fileURI)) continue;
                                    toRemove.add(resource);
                                }
                                if (toRemove.isEmpty()) continue;
                                topLevelElement.runAsCommand(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (Resource resource : toRemove) {
                                            ArrayList contents = new ArrayList();
                                            contents.addAll(resource.getContents());
                                            for (EObject obj : contents) {
                                                EcoreUtil.delete((EObject)obj);
                                            }
                                            resource.unload();
                                            resourceSet.getResources().remove((Object)resource);
                                        }
                                    }
                                });
                            }
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        modelFileChangesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IPersistencyService ps = IPersistencyService.getInstance();
                ps.refreshTopLevelElements(EclipseResourceStorageService.this);
            }
        });
        modelFileChangesJob.schedule();
    }

    public synchronized boolean isLoaded(IFile file) {
        return this.loadedContexts.containsKey(file);
    }

    private void loadContext(IFile file) {
        try {
            ModelContext mc = new ModelContext(file);
            this.loadedContexts.put(file, mc);
            this.rootElementContexts.put(mc.getRootModelElement(), mc);
            this.postLoadContext(mc);
        }
        catch (Exception ioex) {
            String msg = "Exception while loading model file: " + file.getName();
            this.errorFiles.add(new FileModelStorageError(msg, ioex, file));
            LoggingUtils.error(ToolingKernelActivator.getDefault(), msg, ioex);
        }
    }

    public void postLoadContext(ModelContext mc) {
        IMigrationService migs = IMigrationService.getInstance();
        if (migs.needMigration(mc, mc.getUnknownFeatures())) {
            migs.migrate(mc, mc.getUnknownFeatures());
        }
    }

    private void unloadContext(IFile file) {
        ModelContext context = this.loadedContexts.remove(file);
        if (context != null) {
            this.rootElementContexts.remove(context.getRootModelElement());
            context.destroy();
        }
    }

    @Override
    public List<ITopLevelElement> getTopLevelElements() {
        ArrayList<ITopLevelElement> result = new ArrayList<ITopLevelElement>();
        result.addAll(this.rootElementContexts.values());
        return result;
    }

    private void setupLocationProviders() {
        for (IConfigurationElement ce : ExtensionPointUtils.getConfigurationElements(LOCATION_PROVIDER_EXTENSION_POINT_NAME, LOCATION_PROVIDER_CONFIGURATION_ELEMENT_NAME)) {
            Bundle bundle = ExtensionPointUtils.getBundle(ce);
            try {
                Class<?> handlerClass = ExtensionPointUtils.loadClass(ce.getAttribute("provider"), bundle);
                IEclipseResourceStorageLocationProvider provider = (IEclipseResourceStorageLocationProvider)handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.storageProviderList.add(provider);
            }
            catch (Exception ex) {
                LoggingUtils.error(ToolingKernelActivator.getDefault(), ex.getMessage(), ex);
            }
        }
    }

    @Override
    public List<IFile> getModelElementResources() {
        return new ArrayList<IFile>(this.loadedContexts.keySet());
    }

    @Override
    public List<ModelStorageError> getStorageErrors() {
        this.checkFiles();
        return this.errorFiles;
    }

    private void checkFiles() {
        ArrayList<ModelStorageError> iter = new ArrayList<ModelStorageError>(this.errorFiles);
        for (ModelStorageError err : iter) {
            IFile file = ((FileModelStorageError)err).file;
            if (!this.loadedContexts.containsKey(file) && file.exists()) continue;
            this.errorFiles.remove(err);
        }
    }

    @Override
    public String getIntrospectionLabel() {
        return "Eclipse Resource Storage Provider";
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    @Override
    public Collection<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return new EclipseResourceStorageKISSDetailsItem(Collections.unmodifiableList(this.storageProviderList), Collections.unmodifiableSet(this.loadedContexts.keySet()), Collections.unmodifiableList(this.errorFiles));
    }

    @Override
    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThis service implements the storage mechanism using eCore XML files in the Eclipse workspace.\nIt is the default storage mechanism and is registered with the persistency service.\nIt searches the Eclipse workspace directory and its sub-directories for model files and\ncreates top-level elements for it.\nAll existing files are presented to registered instances of IEclipseResourceStorageLocationProvider,\nwhich may then decide if the file extension is correct.\n\nThe service extension point is 'org.fortiss.tooling.kernel.eclipseResourceStorageLocationProvider'.";
    }

    private static class FileModelStorageError
    extends ModelStorageError {
        public IFile file;

        public FileModelStorageError(String msg, Exception cause, IFile file) {
            super(msg, cause);
            this.file = file;
        }
    }
}

