/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.internal.storage.eclipse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.transaction.ExceptionHandler;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.internal.storage.eclipse.AutoUndoCommandStack;
import org.fortiss.tooling.kernel.model.FortissToolingKernelPackage;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.EMFResourceUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

class ModelContext
implements ITopLevelElement,
CommandStackListener {
    private final ResourceSet rset;
    private final IFile file;
    private final Resource resource;
    private final TransactionalEditingDomain editingDomain;
    private final AutoUndoCommandStack transactionalCommandStack;
    private final List<CommandStackListener> listeners = new LinkedList<CommandStackListener>();
    private int maxId = -1;
    private Map<EObject, AnyType> unknownFeatures;

    ModelContext(IFile file) throws IOException {
        this.file = file;
        this.editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        this.rset = this.editingDomain.getResourceSet();
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        this.resource = this.getResourceSet().createResource(uri);
        this.resource.load(EMFResourceUtils.buildOptionsMap());
        this.unknownFeatures = this.resource instanceof XMIResource ? ((XMIResource)this.resource).getEObjectToExtensionMap() : new HashMap<EObject, AnyType>();
        this.transactionalCommandStack = new AutoUndoCommandStack(this.editingDomain);
        this.transactionalCommandStack.addCommandStackListener(this);
        this.transactionalCommandStack.setExceptionHandler(new ExceptionHandler(){

            public void handleException(Exception e) {
                if (!(e instanceof RollbackException)) {
                    LoggingUtils.showError(e.getMessage());
                    LoggingUtils.error(ToolingKernelActivator.getDefault(), e.getMessage(), e);
                }
            }
        });
        this.resource.eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                boolean featureOk;
                super.notifyChanged(notification);
                int eventType = notification.getEventType();
                Object feature = notification.getFeature();
                boolean bl = featureOk = feature == FortissToolingKernelPackage.Literals.IID_LABELED__ID;
                if (eventType == 1 && featureOk) {
                    Object notifier = notification.getNotifier();
                    if (ModelContext.this.resource instanceof XMIResource && notifier instanceof EObject) {
                        String newVal = notification.getNewStringValue();
                        ((XMIResource)ModelContext.this.resource).setID((EObject)notifier, newVal);
                    }
                }
            }
        });
        if (this.checkIDs()) {
            try {
                this.doSave((IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException | CoreException e) {
                LoggingUtils.error(ToolingKernelActivator.getDefault(), "Error saving model file when fixing missing/duplicate IDs.", e);
            }
        }
    }

    @Override
    public String getId(EObject modelElement) {
        return this.resource instanceof XMIResource ? ((XMIResource)this.resource).getID(modelElement) : null;
    }

    @Override
    public EObject getRootModelElement() {
        return (EObject)this.resource.getContents().get(0);
    }

    @Override
    public void addCommandStackListener(CommandStackListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeCommandStackListener(CommandStackListener listener) {
        this.listeners.remove(listener);
    }

    private boolean checkIDs() {
        HashSet<Integer> ids = new HashSet<Integer>();
        HashMap<String, Integer> objWithIdProblem = new HashMap<String, Integer>();
        TreeIterator i = this.getRootModelElement().eAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!(eo instanceof IIdLabeled)) continue;
            IIdLabeled element = (IIdLabeled)eo;
            int id = element.getId();
            if (id <= 0) {
                objWithIdProblem.put(element.toString(), null);
            } else if (ids.contains(id)) {
                objWithIdProblem.put(element.toString(), element.getId());
                this.runAsNonDirtyingCommand(() -> element.setId(0));
            } else {
                ids.add(id);
            }
            this.maxId = Math.max(this.maxId, id);
        }
        this.maxId = Math.max(0, this.maxId);
        if (!objWithIdProblem.isEmpty()) {
            this.runAsNonDirtyingCommand(() -> {
                this.maxId = UniqueIDUtils.generateMissingIDs(this.getRootModelElement(), this.maxId);
            });
            Object msg = "The following missing/duplicate IDs have been fixed in \"";
            msg = (String)msg + this.resource.getURI().lastSegment() + "\".\n";
            msg = (String)msg + "Please report this incident since it indicates a programming error ";
            msg = (String)msg + "that could result in corrupted model files.\n";
            int count = 0;
            int maxErrorMessages = 100;
            for (Map.Entry entry : objWithIdProblem.entrySet()) {
                Integer id = (Integer)entry.getValue();
                msg = id == null ? (String)msg + "  Missing ID added to " : (String)msg + "  Duplicate ID " + String.valueOf(id) + " disambiguated for ";
                String name = (String)entry.getKey();
                msg = (String)msg + "element \"" + name + "\"\n";
                if (count++ < 100) continue;
                msg = (String)msg + "\n\n*** More than 100 IDs have been fixed. Stopping report. Note that all detected problems have been fixed. ***";
                break;
            }
            LoggingUtils.error(ToolingKernelActivator.getDefault(), (String)msg);
            return true;
        }
        return false;
    }

    @Override
    public void prepareIDs(EObject other) {
        this.maxId = UniqueIDUtils.prepareIDs(other, this.getRootModelElement(), this.maxId);
    }

    public void destroy() {
        ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
        this.transactionalCommandStack.removeCommandStackListener(this);
    }

    public IFile getFile() {
        return this.file;
    }

    @Override
    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    @Override
    public synchronized void doSave(IProgressMonitor monitor) throws IOException, CoreException {
        Throwable exception;
        block19: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Saving model...", (int)4);
            this.checkIDs();
            Diagnostic validate = Diagnostician.INSTANCE.validate(this.getRootModelElement());
            if (validate.getSeverity() != 0) {
                LoggingUtils.warning(ToolingKernelActivator.getDefault(), this.getFullMessage(validate));
            }
            subMonitor.worked(1);
            exception = null;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            Map<String, Object> saveOptions = EMFResourceUtils.buildOptionsMap();
            try {
                try {
                    this.resource.save((OutputStream)bytes, saveOptions);
                    subMonitor.worked(1);
                }
                catch (IOException e) {
                    exception = e;
                    try {
                        SubMonitor child1 = subMonitor.split(1);
                        ByteArrayInputStream stream = new ByteArrayInputStream(bytes.toByteArray());
                        this.file.refreshLocal(0, (IProgressMonitor)child1);
                        child1.done();
                        SubMonitor child2 = subMonitor.split(1);
                        this.file.setContents((InputStream)stream, false, true, (IProgressMonitor)child2);
                        child2.done();
                    }
                    catch (CoreException e2) {
                        if (exception == null) {
                            exception = e2;
                        }
                        break block19;
                    }
                }
            }
            catch (Throwable throwable) {
                block20: {
                    try {
                        SubMonitor child1 = subMonitor.split(1);
                        ByteArrayInputStream stream = new ByteArrayInputStream(bytes.toByteArray());
                        this.file.refreshLocal(0, (IProgressMonitor)child1);
                        child1.done();
                        SubMonitor child2 = subMonitor.split(1);
                        this.file.setContents((InputStream)stream, false, true, (IProgressMonitor)child2);
                        child2.done();
                    }
                    catch (CoreException e) {
                        if (exception != null) break block20;
                        exception = e;
                    }
                }
                throw throwable;
            }
            try {
                SubMonitor child1 = subMonitor.split(1);
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes.toByteArray());
                this.file.refreshLocal(0, (IProgressMonitor)child1);
                child1.done();
                SubMonitor child2 = subMonitor.split(1);
                this.file.setContents((InputStream)stream, false, true, (IProgressMonitor)child2);
                child2.done();
            }
            catch (CoreException e) {
                if (exception != null) break block19;
                exception = e;
            }
        }
        monitor.done();
        if (exception == null) {
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.performNotifyListeners(this.editingDomain.getCommandStack());
            IPersistencyService ps = IPersistencyService.getInstance();
            if (ps != null) {
                ps.notifyTopLevelElementChanged(this);
            }
        } else {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CoreException) {
                throw (CoreException)exception;
            }
            assert (false);
        }
    }

    private String getFullMessage(Diagnostic diagnostic) {
        Object res = new String();
        if (diagnostic.getSeverity() != 0) {
            res = diagnostic.getMessage();
            for (Diagnostic child : diagnostic.getChildren()) {
                String childMessage = this.getFullMessage(child);
                res = (String)res + (childMessage.isEmpty() ? "" : "\n") + childMessage;
            }
        }
        return res;
    }

    @Override
    public void runAsCommand(final Runnable runnable) {
        this.transactionalCommandStack.execute((Command)new AbstractCommand(){

            public boolean canExecute() {
                return true;
            }

            public void execute() {
                runnable.run();
            }

            public void redo() {
            }
        });
    }

    @Override
    public void runAsNonDirtyingCommand(final Runnable runnable) {
        try {
            this.transactionalCommandStack.executeNonDirtyingNonUndoing((Command)new AbstractCommand(){

                public void execute() {
                    runnable.run();
                }

                public boolean canExecute() {
                    return true;
                }

                public void redo() {
                }

                public boolean canUndo() {
                    return false;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            String msg = "Problem with synchronizing library and model!";
            LoggingUtils.error(ToolingKernelActivator.getDefault(), msg, e);
        }
    }

    void performNotifyListeners(CommandStack commandStack) {
        try {
            Method notifyListenersMethod = BasicCommandStack.class.getDeclaredMethod("notifyListeners", new Class[0]);
            notifyListenersMethod.setAccessible(true);
            notifyListenersMethod.invoke((Object)commandStack, new Object[0]);
        }
        catch (Exception e) {
            LoggingUtils.error(ToolingKernelActivator.getDefault(), "Notification after save failed!", e);
        }
    }

    @Override
    public boolean canUndo() {
        return this.transactionalCommandStack.canUndo();
    }

    @Override
    public boolean canRedo() {
        return this.transactionalCommandStack.canRedo();
    }

    @Override
    public void undo() {
        this.transactionalCommandStack.undo();
    }

    @Override
    public void redo() {
        this.transactionalCommandStack.redo();
    }

    @Override
    public String getSaveableName() {
        return this.getFile().getName();
    }

    public void commandStackChanged(EventObject event) {
        EventObject relayEvent = new EventObject(this);
        LinkedList<CommandStackListener> frozenListeners = new LinkedList<CommandStackListener>(this.listeners);
        for (CommandStackListener l : frozenListeners) {
            l.commandStackChanged(relayEvent);
        }
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public boolean delete() {
        try {
            this.getFile().delete(false, null);
        }
        catch (CoreException e) {
            String msg = "Error during deletion of model file " + this.getFile().getName() + ".";
            LoggingUtils.error(ToolingKernelActivator.getDefault(), msg);
            return false;
        }
        return true;
    }

    @Override
    public ResourceSet getResourceSet() {
        return this.rset;
    }

    public Map<EObject, AnyType> getUnknownFeatures() {
        return this.unknownFeatures;
    }
}

