/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.introspection;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;

public final class KernelIntrospectionSystemService
implements IKernelIntrospectionSystemService,
IIntrospectiveKernelService {
    private static final KernelIntrospectionSystemService INSTANCE = new KernelIntrospectionSystemService();
    private final HashSet<IIntrospectiveKernelService> services = new HashSet();

    public static KernelIntrospectionSystemService getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerService(IIntrospectiveKernelService service) {
        System.out.println("[KISS] " + service.getIntrospectionLabel() + " registered.");
        this.services.add(service);
    }

    @Override
    public void unregisterService(IIntrospectiveKernelService service) {
        this.services.remove(service);
    }

    @Override
    public String getIntrospectionLabel() {
        return "Kernel Introspection System Service";
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    public Set<IIntrospectionItem> getIntrospectionItems() {
        return Collections.unmodifiableSet(this.services);
    }

    @Override
    public String getIntrospectionDescription() {
        return this.getIntrospectionLabel() + "\n\nThis service manages the kernel introspection system. Its purpose is to make all services\nself-describing. All other kernel services register with it and provide their introspection\ndata items, which can be reviewed from within the running kernel instance. This service \nresembles the idea of the Linux kernel 'sysfs'.";
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return null;
    }
}

