/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.service.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.base.IObjectAware2;
import org.fortiss.tooling.kernel.utils.ExtensionPointUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.osgi.framework.Bundle;

public abstract class ObjectAware2ServiceBase<T extends IObjectAware2<? extends Object, ? extends Object>>
implements IIntrospectiveKernelService {
    protected final Map<Class<?>, Map<Class<?>, List<T>>> handlersBySource = new HashMap();
    protected final Map<Class<?>, Map<Class<?>, List<T>>> handlersByTarget = new HashMap();

    protected abstract String getExtensionPointName();

    protected abstract String getConfigurationElementName();

    protected abstract String getHandlerClassAttribute();

    public void initializeService() {
        this.setupHandlerMap();
    }

    public void startService() {
    }

    protected String getSourceAttribute() {
        return "source";
    }

    protected String getTargetAttribute() {
        return "target";
    }

    protected String getClassConfigurationElement() {
        return "objectClass";
    }

    protected String getClassAttribute() {
        return "objectClass";
    }

    protected boolean requiresUniqueHandler() {
        return false;
    }

    public List<T> getRegisteredHandlers(Class<?> sourceModelElementClass, Class<?> targetModelElementClass) {
        Map innerMap = (Map)ReflectionUtils.performNearestClassLookup(sourceModelElementClass, this.handlersBySource);
        if (innerMap == null) {
            return null;
        }
        return (List)ReflectionUtils.performNearestClassLookup(targetModelElementClass, (Map)innerMap);
    }

    private void setupHandlerMap() {
        for (IConfigurationElement ce : ExtensionPointUtils.getConfigurationElements(this.getExtensionPointName(), this.getConfigurationElementName())) {
            try {
                this.createHandler(ce);
            }
            catch (Exception e) {
                LoggingUtils.error(ToolingKernelActivator.getDefault(), "Error reading connector extension!", e);
            }
        }
    }

    private void createHandler(IConfigurationElement ce) throws Exception {
        Bundle bundle = ExtensionPointUtils.getBundle(ce);
        Class<?> handlerClass = ExtensionPointUtils.loadClass(ce.getAttribute(this.getHandlerClassAttribute()), bundle);
        IObjectAware2 handler = (IObjectAware2)handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        ArrayList sources = new ArrayList();
        ArrayList targets = new ArrayList();
        IConfigurationElement[] iConfigurationElementArray = ce.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            if (iConfigurationElement.getName().equals(this.getSourceAttribute())) {
                this.addRegisteredClasses(iConfigurationElement, sources, bundle);
            } else if (iConfigurationElement.getName().equals(this.getTargetAttribute())) {
                this.addRegisteredClasses(iConfigurationElement, targets, bundle);
            }
            ++n2;
        }
        for (Class clazz : sources) {
            for (Class clazz2 : targets) {
                this.addHandler(clazz, clazz2, handler);
            }
        }
    }

    private void addRegisteredClasses(IConfigurationElement element, List<Class<?>> list, Bundle bundle) throws ClassNotFoundException {
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(this.getClassConfigurationElement());
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            Class<?> modelElementClass = ExtensionPointUtils.loadClass(ce.getAttribute(this.getClassAttribute()), bundle);
            list.add(modelElementClass);
            ++n2;
        }
    }

    protected final void addHandler(Class<?> sourceElementClass, Class<?> targetElementClass, T handler) {
        this.insertStorage(this.handlersBySource, sourceElementClass, targetElementClass, handler);
        this.insertStorage(this.handlersByTarget, targetElementClass, sourceElementClass, handler);
    }

    private void insertStorage(Map<Class<?>, Map<Class<?>, List<T>>> map, Class<?> key1, Class<?> key2, T handler) {
        List<T> list;
        Map<Class<?>, List<T>> innerMap = map.get(key1);
        if (innerMap == null) {
            innerMap = new HashMap();
            map.put(key1, innerMap);
        }
        if ((list = innerMap.get(key2)) == null) {
            list = new ArrayList<T>();
            innerMap.put(key2, list);
        }
        if (this.requiresUniqueHandler() && !list.isEmpty()) {
            LoggingUtils.warning(ToolingKernelActivator.getDefault(), "Encountered more than one handler registered with " + this.getExtensionPointName() + "(" + String.valueOf(handler.getClass()) + "," + String.valueOf(((IObjectAware2)list.get(0)).getClass()) + ")");
        }
        list.add(handler);
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    @Override
    public Collection<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return null;
    }
}

