/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.service.base;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.introspection.IIntrospectionDetailsItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectionItem;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.base.IObjectAware;
import org.fortiss.tooling.kernel.utils.ExtensionPointUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.osgi.framework.Bundle;

public abstract class ObjectAwareServiceBase<T extends IObjectAware<? extends Object>>
implements IIntrospectiveKernelService {
    protected final Map<Class<?>, List<T>> handlerMap = this.createHandlerMap();
    protected final Set<T> allHandlersSet = new HashSet<T>();

    public List<T> getRegisteredHandlers(Class<?> modelElementClass) {
        return (List)ReflectionUtils.performNearestClassLookup(modelElementClass, this.handlerMap);
    }

    public Set<T> getAllHandlers() {
        return this.allHandlersSet;
    }

    public void initializeService() {
        this.setupHandlerMap();
    }

    public void startService() {
    }

    protected Map<Class<?>, List<T>> createHandlerMap() {
        return new HashMap();
    }

    private void setupHandlerMap() {
        for (IConfigurationElement ce : ExtensionPointUtils.getConfigurationElements(this.getExtensionPointName(), this.getConfigurationElementName())) {
            Bundle bundle = ExtensionPointUtils.getBundle(ce);
            try {
                Class<?> handlerClass = ExtensionPointUtils.loadClass(ce.getAttribute(this.getHandlerClassAttribute()), bundle);
                IObjectAware handler = (IObjectAware)handlerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                IConfigurationElement[] iConfigurationElementArray = ce.getChildren(this.getClassConfigurationElement());
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement ce2 = iConfigurationElementArray[n2];
                    Class<?> modelElementClass = ExtensionPointUtils.loadClass(ce2.getAttribute(this.getClassAttribute()), bundle);
                    this.addHandler(modelElementClass, handler);
                    ++n2;
                }
            }
            catch (Exception ex) {
                LoggingUtils.error(ToolingKernelActivator.getDefault(), ex.getMessage(), ex);
            }
        }
    }

    protected void addHandler(Class<?> modelElementClass, T handler) {
        List<T> list = this.handlerMap.get(modelElementClass);
        if (list == null) {
            list = new LinkedList<T>();
            this.handlerMap.put(modelElementClass, list);
        }
        if (this.requiresUniqueHandler() && !list.isEmpty()) {
            LoggingUtils.warning(ToolingKernelActivator.getDefault(), "Encountered more than one handler registered with " + this.getExtensionPointName() + "(" + String.valueOf(handler.getClass()) + "," + String.valueOf(((IObjectAware)list.get(0)).getClass()) + ")");
        }
        list.add(handler);
        this.allHandlersSet.add(handler);
    }

    protected abstract String getExtensionPointName();

    protected abstract String getConfigurationElementName();

    protected abstract String getHandlerClassAttribute();

    protected boolean requiresUniqueHandler() {
        return false;
    }

    protected String getClassConfigurationElement() {
        return "objectClass";
    }

    protected String getClassAttribute() {
        return "objectClass";
    }

    @Override
    public boolean showInIntrospectionNavigation() {
        return true;
    }

    @Override
    public Collection<IIntrospectionItem> getIntrospectionItems() {
        return Collections.emptyList();
    }

    @Override
    public IIntrospectionDetailsItem getDetailsItem() {
        return null;
    }
}

