/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.service.types;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.service.types.EMFTypeMap;
import org.fortiss.tooling.kernel.service.types.TypeSet;

public class EMFTypeToTypeSetMap<S extends EObject, T>
extends EMFTypeMap<S, TypeSet<T>> {
    public void addTypeSetEntry(Class<? extends S> sourceType, Class<? extends T> targetType) {
        TypeSet typeSet = (TypeSet)this.get(sourceType);
        if (typeSet == null) {
            typeSet = new TypeSet();
            this.put(sourceType, typeSet);
        }
        typeSet.add(targetType);
    }

    public Collection<Class<? extends S>> getSourceTypes() {
        return Collections.unmodifiableCollection(this.keySet());
    }

    public Collection<Class<? extends S>> getSourceTypes(Class<? extends T> targetType) {
        Predicate<Class> referencesTargetType = key -> ((TypeSet)this.get(key)).contains(targetType);
        return this.keySet().stream().filter(referencesTargetType).collect(Collectors.toList());
    }

    public Collection<Class<? extends T>> getTargetTypes(Class<? extends S> sourceType) {
        TypeSet rval = (TypeSet)this.get(sourceType);
        return rval != null ? Collections.unmodifiableCollection(rval) : Collections.emptyList();
    }
}

