/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.collections.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public final class EMFResourceUtils {
    public static void createNewEclipseWorkspaceProject(IFile file, EObject modelRootElement) throws IOException {
        Resource r = new ResourceSetImpl().createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
        r.getContents().add((Object)modelRootElement);
        r.save(EMFResourceUtils.buildOptionsMap());
    }

    public static EObject loadModelFromFile(URI uri) {
        try {
            return (EObject)EMFResourceUtils.loadModelFromFileWithUnknownFeatures(uri).getFirst();
        }
        catch (Exception ex) {
            LoggingUtils.error(ToolingKernelActivator.getDefault(), "Failed to load model from " + uri.toString());
            return null;
        }
    }

    public static void refreshWorkspace() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (Exception e) {
            LoggingUtils.error(ToolingKernelActivator.getDefault(), "Cannot refresh workspace!", e);
        }
    }

    public static Map<String, Object> buildOptionsMap() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "UTF-8");
        options.put("RECORD_UNKNOWN_FEATURE", true);
        options.put("ZIP", false);
        options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        options.put("DEFER_ATTACHMENT", true);
        options.put("DEFER_IDREF_RESOLUTION", true);
        return options;
    }

    private static Pair<EObject, Map<EObject, AnyType>> loadModelFromFileWithUnknownFeatures(URI uri) {
        return EMFResourceUtils.loadModelFromFileWithUnknownFeatures(uri, EObject.class);
    }

    private static Pair<EObject, Map<EObject, AnyType>> loadModelFromFileWithUnknownFeatures(URI uri, Class<?> topLevelClass) {
        try {
            Map unknownFeatures;
            ResourceSetImpl rset = new ResourceSetImpl();
            Resource r = rset.createResource(uri);
            r.load(EMFResourceUtils.buildOptionsMap());
            Map map = unknownFeatures = r instanceof XMIResource ? ((XMIResource)r).getEObjectToExtensionMap() : new HashMap();
            if (!r.getContents().isEmpty()) {
                for (EObject content : r.getContents()) {
                    if (!topLevelClass.isAssignableFrom(content.getClass())) continue;
                    return new Pair((Object)content, unknownFeatures);
                }
            }
        }
        catch (IOException ex) {
            LoggingUtils.error(ToolingKernelActivator.getDefault(), "Failed to load model from " + uri.toString(), ex);
        }
        return null;
    }
}

