/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.Charsets;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.osgi.framework.Bundle;

public abstract class EcoreSerializerBase<R extends EObject> {
    private String eNsURI;
    private EPackage ePackage;
    private Resource.Factory resourceFactory;
    private Charset charset;
    private String schemaFileName;
    private boolean doValidate;
    private boolean exceptionOnValidationError;
    private BasicDiagnostic lastDiagnostic;

    public EcoreSerializerBase(String eNsURI, EPackage ePackage, Resource.Factory resourceFactory, Charset charset, String schemaFileName, boolean doValidate, boolean exceptionOnValidationError) {
        this.eNsURI = eNsURI;
        this.ePackage = ePackage;
        this.resourceFactory = resourceFactory;
        this.charset = charset;
        this.schemaFileName = schemaFileName;
        this.doValidate = doValidate;
        this.exceptionOnValidationError = exceptionOnValidationError;
    }

    public EcoreSerializerBase(String eNsURI, EPackage ePackage, Resource.Factory resourceFactory) {
        this(eNsURI, ePackage, resourceFactory, Charsets.UTF_8, null, true, false);
    }

    public final R load(String pathName) throws IOException, DiagnosticException {
        return this.load(this.createLoadURI(pathName));
    }

    public final R load(URI uri) throws IOException, DiagnosticException {
        ResourceSet resourceSet = this.createResourceSet();
        Resource resource = resourceSet.getResource(uri, true);
        if (resource.getContents().isEmpty()) {
            return null;
        }
        R rootElement = this.getRootElement((EObject)resource.getContents().get(0));
        this.validate((EObject)rootElement);
        return rootElement;
    }

    public final URI save(R rootElement, String pathName) throws IOException, DiagnosticException {
        URI uri = this.createSaveURI(pathName);
        this.save(rootElement, uri);
        return uri;
    }

    public final void save(R rootElement, URI uri) throws IOException, DiagnosticException {
        ResourceSet resourceSet = this.createResourceSet();
        Resource resource = resourceSet.createResource(uri);
        resource.getContents().add(rootElement);
        this.validate((EObject)rootElement);
        this.saveResource(resource, null);
    }

    protected void saveResource(Resource resource, OutputStream ostream) throws IOException {
        if (resource instanceof XMLResource) {
            ((XMLResource)resource).setEncoding(this.charset.name());
        }
        if (ostream == null) {
            resource.save(this.getOptions());
        } else {
            resource.save(ostream, this.getOptions());
        }
    }

    private Map<Object, Object> getOptions() {
        Map<Object, Object> options = this.getSpecificOptions();
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        if (this.schemaFileName != null) {
            options.put("SCHEMA_LOCATION", Boolean.TRUE);
        }
        return options;
    }

    protected Map<Object, Object> getSpecificOptions() {
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        options.put("KEEP_DEFAULT_CONTENT", Boolean.FALSE);
        options.put("USE_LEXICAL_HANDLER", Boolean.TRUE);
        return options;
    }

    public Diagnostic getLastDiagnostic() {
        return this.lastDiagnostic;
    }

    protected abstract R getRootElement(EObject var1);

    protected final URI createFileURI(String pathName) {
        return URI.createFileURI((String)pathName);
    }

    protected final URI createBundleURI(String bundlePathName, Bundle bundle) {
        return URI.createPlatformPluginURI((String)new Path(bundle.getSymbolicName()).append(bundlePathName).toString(), (boolean)true);
    }

    protected final URI createTemporaryFileURI(String fileName, String extension) throws IOException {
        if (!((String)extension).startsWith(".")) {
            extension = "." + (String)extension;
        }
        if (fileName.endsWith((String)extension)) {
            fileName = fileName.substring(0, fileName.length() - ((String)extension).length());
        }
        File tempFile = File.createTempFile(fileName, (String)extension);
        tempFile.deleteOnExit();
        return URI.createFileURI((String)tempFile.getAbsolutePath());
    }

    protected URI createLoadURI(String pathName) throws IOException {
        return this.createFileURI(pathName);
    }

    protected URI createSaveURI(String pathName) throws IOException {
        return this.createFileURI(pathName);
    }

    protected final ResourceSet createResourceSet() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl(){

            public Map<Object, Object> getLoadOptions() {
                return EcoreSerializerBase.this.getOptions();
            }
        };
        resourceSet.getPackageRegistry().put((Object)this.eNsURI, (Object)this.ePackage);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", this.resourceFactory);
        if (this.schemaFileName != null) {
            Resource packageResource = resourceSet.createResource(URI.createURI((String)this.schemaFileName));
            packageResource.getContents().add((Object)this.ePackage);
        }
        return resourceSet;
    }

    private void validate(EObject obj) throws DiagnosticException {
        if (!this.doValidate) {
            this.lastDiagnostic = null;
            return;
        }
        Diagnostician diagnostician = new Diagnostician();
        Map context = diagnostician.createDefaultContext();
        this.lastDiagnostic = new PrettyPrintingDiagnostics(obj);
        if (diagnostician.validate(obj, (DiagnosticChain)this.lastDiagnostic, context)) {
            this.lastDiagnostic = null;
        } else if (this.exceptionOnValidationError) {
            throw new DiagnosticException((Diagnostic)this.lastDiagnostic);
        }
    }

    private final class PrettyPrintingDiagnostics
    extends BasicDiagnostic {
        private PrettyPrintingDiagnostics(EObject obj) {
            super("EcoreSerializer", 0, "Diagnosis of " + EcoreUtil.getIdentification((EObject)obj), new Object[]{obj});
        }

        public String getMessage() {
            return this.getMessage((Diagnostic)this, "");
        }

        private String getMessage(Diagnostic diagnostic, String indent) {
            StringBuffer rval = new StringBuffer();
            rval.append(indent);
            if (diagnostic instanceof PrettyPrintingDiagnostics) {
                rval.append(super.getMessage());
            } else {
                rval.append(diagnostic.getMessage());
            }
            rval.append("\n");
            if (diagnostic instanceof BasicDiagnostic) {
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    rval.append(this.getMessage(childDiagnostic, indent + "  "));
                }
            }
            return rval.toString();
        }
    }
}

