/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.osgi.framework.Bundle;

public class ExtensionPointUtils {
    public static Class<?> loadClass(String className, Bundle bundle) throws ClassNotFoundException {
        if (className == null) {
            throw new ClassNotFoundException("Class name not configured.");
        }
        return bundle.loadClass(className);
    }

    public static Bundle getBundle(IConfigurationElement configElement) {
        return Platform.getBundle((String)configElement.getDeclaringExtension().getNamespaceIdentifier());
    }

    public static List<IConfigurationElement> getConfigurationElements(String extensionPointName, String configurationElementName) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(extensionPointName);
        if (extensionPoint == null) {
            LoggingUtils.error(ToolingKernelActivator.getDefault(), "Could not find extension point " + extensionPointName);
            return Collections.EMPTY_LIST;
        }
        ArrayList<IConfigurationElement> configurationElements = new ArrayList<IConfigurationElement>();
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension e = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equals(configurationElementName)) {
                    configurationElements.add(ce);
                }
                ++n4;
            }
            ++n2;
        }
        return configurationElements;
    }
}

