/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.utils;

import java.util.Comparator;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class HierarchicalNameComparator
implements Comparator<Object> {
    private int compareByNameIdHashCode(Object o1, Object o2) {
        if (o1 instanceof INamedElement && o2 instanceof INamedElement) {
            int rval;
            String name1 = ((INamedElement)o1).getName();
            String name2 = ((INamedElement)o2).getName();
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            if ((rval = name1.compareTo(name2)) != 0) {
                return rval;
            }
        }
        if (o1 instanceof IIdLabeled && o2 instanceof IIdLabeled) {
            return Integer.compare(((IIdLabeled)o1).getId(), ((IIdLabeled)o2).getId());
        }
        return Integer.compare(o1.hashCode(), o2.hashCode());
    }

    @Override
    public int compare(Object o1, Object o2) {
        int modelElement2Level;
        if (!(o1 instanceof EObject) || !(o2 instanceof EObject)) {
            return this.compareByNameIdHashCode(o1, o2);
        }
        EObject modelElement1 = (EObject)o1;
        EObject modelElement2 = (EObject)o2;
        EObject e1 = modelElement1;
        EObject e2 = modelElement2;
        int modelElement1Level = EcoreUtils.getModelElementLevel(modelElement1);
        if (modelElement1Level < (modelElement2Level = EcoreUtils.getModelElementLevel(modelElement2))) {
            levelsUp = modelElement2Level - modelElement1Level;
            ancestor = EcoreUtils.getModelElementAncestor(modelElement2, levelsUp);
            if (modelElement1 == ancestor) {
                return -1;
            }
            e2 = ancestor;
        } else if (modelElement1Level > modelElement2Level) {
            levelsUp = modelElement1Level - modelElement2Level;
            ancestor = EcoreUtils.getModelElementAncestor(modelElement1, levelsUp);
            if (modelElement2 == ancestor) {
                return 1;
            }
            e1 = ancestor;
        }
        while (e1.eContainer() != e2.eContainer()) {
            e1 = e1.eContainer();
            e2 = e2.eContainer();
        }
        return this.compareByNameIdHashCode(e1, e2);
    }
}

