/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.IIdLabeledReference;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public final class KernelModelElementUtils {
    public static <T extends IProjectRootElement> T getRootElement(EObject element, Class<T> clazz) {
        EObject root = KernelModelElementUtils.getRootElementContainer(element);
        return (T)((IProjectRootElement)EcoreUtils.pickFirstInstanceOf(clazz, root.eContents()));
    }

    public static <T extends IProjectRootElement> List<T> getRootElements(EObject element, Class<T> clazz) {
        EObject root = KernelModelElementUtils.getRootElementContainer(element);
        return EcoreUtils.pickInstanceOf(clazz, root.eContents());
    }

    public static Collection<IProjectRootElement> getRootElements(EObject element, Collection<Class<? extends IProjectRootElement>> types) {
        List<IProjectRootElement> rootElements = KernelModelElementUtils.getRootElements(element, IProjectRootElement.class);
        return LambdaUtils.filter(rootElements, r -> ReflectionUtils.isInstanceOfAny((Object)r, (Class[])((Class[])types.toArray(Class[]::new))));
    }

    private static <T extends IProjectRootElement> EObject getRootElementContainer(EObject element) {
        EObject root;
        ITopLevelElement topelement = IPersistencyService.getInstance().getTopLevelElementFor(element);
        if (topelement == null) {
            root = element;
            while (root.eContainer() != null) {
                root = root.eContainer();
            }
        } else {
            root = topelement.getRootModelElement();
        }
        return root;
    }

    public static <T extends EObject> T getParentElement(EObject element, Class<T> targetClass, boolean isReflexive) {
        if (element == null) {
            return null;
        }
        EObject currentParent = isReflexive ? element : element.eContainer();
        while (currentParent != null && !targetClass.isAssignableFrom(currentParent.getClass())) {
            currentParent = currentParent.eContainer();
        }
        return (T)currentParent;
    }

    public static <T extends EObject> List<T> getParentElements(EObject element, Class<T> targetClass) {
        ArrayList<EObject> retList = new ArrayList<EObject>();
        EObject currentElement = element;
        while (currentElement != null && !(currentElement instanceof IProjectRootElement)) {
            if (targetClass.isAssignableFrom(currentElement.getClass())) {
                retList.add(currentElement);
            }
            currentElement = currentElement.eContainer();
        }
        return retList;
    }

    public static EObject findReferencedElement(IIdLabeledReference reference) {
        ITopLevelElement topelement = IPersistencyService.getInstance().getTopLevelElementFor(reference);
        return KernelModelElementUtils.findElementById(reference.getIdReference(), topelement.getRootModelElement());
    }

    public static IIdLabeled findElementById(int id, EObject root) {
        if (root instanceof IIdLabeled && ((IIdLabeled)root).getId() == id) {
            return (IIdLabeled)root;
        }
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            EObject eo = (EObject)iter.next();
            if (!(eo instanceof IIdLabeled) || ((IIdLabeled)eo).getId() != id) continue;
            return (IIdLabeled)eo;
        }
        return null;
    }

    public static boolean isChildElementOf(EObject element, EObject parentElement) {
        while (element.eContainer() != null) {
            if (element.eContainer() == parentElement) {
                return true;
            }
            element = element.eContainer();
        }
        return false;
    }

    public static EList<EObject> topParents(EList<EObject> objs) {
        BasicEList res = new BasicEList();
        for (EObject o1 : objs) {
            boolean hasParent = false;
            for (EObject o2 : objs) {
                if (!KernelModelElementUtils.isChildElementOf(o1, o2)) continue;
                hasParent = true;
                break;
            }
            if (hasParent) continue;
            res.add((Object)o1);
        }
        return res;
    }

    public static <T extends INamedElement> T findContentElementByNameAndClass(EObject root, String name, Class<T> clazz) {
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            EObject nxt = (EObject)iter.next();
            if (!clazz.isInstance(nxt) || !((INamedElement)nxt).getName().equals(name)) continue;
            return (T)((INamedElement)nxt);
        }
        return null;
    }

    private static void prependName(StringBuilder sb, EObject current) {
        if (current instanceof INamedElement) {
            if (sb.length() != 0) {
                sb.insert(0, ".");
            }
            sb.insert(0, ((INamedElement)current).getName());
        }
    }

    public static String computeRelativeName(INamedElement parent, INamedElement element) {
        StringBuilder sb = new StringBuilder();
        INamedElement current = element;
        while (current != null && current != parent) {
            KernelModelElementUtils.prependName(sb, current);
            current = current.eContainer();
        }
        if (current == null) {
            return null;
        }
        return sb.toString();
    }

    public static String computeFullyQualifiedName(INamedElement element) {
        return KernelModelElementUtils.computeFullyQualifiedName(element, true);
    }

    public static String computeFullyQualifiedName(INamedElement element, boolean includeTopLevel) {
        StringBuilder sb = new StringBuilder();
        INamedElement current = element;
        while (current.eContainer() != null) {
            KernelModelElementUtils.prependName(sb, current);
            current = current.eContainer();
        }
        if (includeTopLevel) {
            KernelModelElementUtils.prependName(sb, current);
        }
        return sb.toString();
    }

    public static void runAsCommand(EObject element, Runnable command) {
        ICommandStackService.getInstance().runAsCommand(element, command);
    }

    public static <T extends INamedCommentedElement> T setNameComment(T t, String name, String comment) {
        t.setName(name);
        t.setComment(comment);
        return t;
    }
}

