/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.utils;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public abstract class KernelServiceBasedModelListenerBase<T extends EObject>
implements CommandStackListener {
    private static final IPersistencyService persistencyService = IPersistencyService.getInstance();
    private static final ICommandStackService commandStackService = ICommandStackService.getInstance();
    private final List<Notification> notifications = new ArrayList<Notification>();
    private final T modelElement;
    private Adapter emfAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            KernelServiceBasedModelListenerBase.this.addNotification(notification);
        }
    };

    public KernelServiceBasedModelListenerBase(T modelElement, Adapter emfAdapter) {
        this.modelElement = modelElement;
        this.emfAdapter = emfAdapter;
    }

    public KernelServiceBasedModelListenerBase(T modelElement) {
        this.modelElement = modelElement;
    }

    public void updateComplete(List<Notification> notifications) {
    }

    protected final void addNotification(Notification event) {
        this.notifications.add(event);
    }

    public final void register() {
        this.notifications.clear();
        ITopLevelElement root = persistencyService.getTopLevelElementFor((EObject)this.modelElement);
        commandStackService.addCommandStackListener(root, this);
        this.modelElement.eAdapters().add((Object)this.emfAdapter);
    }

    public final void unregister() {
        this.modelElement.eAdapters().remove((Object)this.emfAdapter);
        ITopLevelElement root = persistencyService.getTopLevelElementFor((EObject)this.modelElement);
        commandStackService.removeCommandStackListener(root, this);
        this.notifications.clear();
    }

    public void commandStackChanged(EventObject event) {
        if (this.notifications.isEmpty()) {
            return;
        }
        this.updateComplete(this.notifications);
        this.notifications.clear();
    }
}

