/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.fortiss.tooling.kernel.extension.base.DialogMessage;
import org.fortiss.tooling.kernel.service.ILoggingService;

public class LoggingUtils {
    private static void log(Plugin plugin, String message, int severity, Throwable cause) {
        String pluginId = plugin.getBundle().getSymbolicName();
        Status status = new Status(severity, pluginId, message, cause);
        plugin.getLog().log((IStatus)status);
    }

    public static void error(Plugin plugin, String message, Throwable cause) {
        LoggingUtils.log(plugin, message, 4, cause);
    }

    public static void error(Plugin plugin, String message) {
        LoggingUtils.error(plugin, message, null);
    }

    public static void warning(Plugin plugin, String message, Throwable cause) {
        LoggingUtils.log(plugin, message, 2, cause);
    }

    public static void warning(Plugin plugin, String message) {
        LoggingUtils.warning(plugin, message, null);
    }

    public static void info(Plugin plugin, String message, Throwable cause) {
        LoggingUtils.log(plugin, message, 1, cause);
    }

    public static void info(Plugin plugin, String message) {
        LoggingUtils.info(plugin, message, null);
    }

    public static void showError(String message) {
        ILoggingService.getInstance().processMessage(new DialogMessage(message, DialogMessage.MSG_TYPE.ERROR), null);
    }

    public static void showWarning(String message) {
        ILoggingService.getInstance().processMessage(new DialogMessage(message, DialogMessage.MSG_TYPE.WARNING), null);
    }

    public static void showInfo(String message) {
        ILoggingService.getInstance().processMessage(new DialogMessage(message, DialogMessage.MSG_TYPE.INFORMATION), null);
    }
}

