/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.xml.sax.helpers.DefaultHandler;

public final class ResourceUtils {
    public static String getResourceURI(String pluginId, String path) {
        if (pluginId == null) {
            throw new NullPointerException("The plugin ID must not be null!");
        }
        if (path == null) {
            throw new NullPointerException("The path must not be null!");
        }
        if (!pluginId.endsWith("/") && !((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return "platform:/plugin/" + pluginId + (String)path;
    }

    public static List<String> getStringContentFromResource(String pluginId, String absPath) throws IOException {
        String l;
        URL url = new URL(ResourceUtils.getResourceURI(pluginId, absPath));
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
        while ((l = r.readLine()) != null) {
            result.add(l);
        }
        return result;
    }

    public static ITopLevelElement getTopLevelElement(URI uri) {
        List<ITopLevelElement> elems = IPersistencyService.getInstance().getTopLevelElements();
        for (ITopLevelElement topLevelElement : elems) {
            for (Resource resource : topLevelElement.getResourceSet().getResources()) {
                if (!resource.getURI().equals(uri)) continue;
                return topLevelElement;
            }
        }
        return null;
    }

    public static <T extends EObject> T getModel(ResourceSet resourceSet, Class<T> clazz) {
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        for (Resource resource : resourceSet.getResources()) {
            for (EObject obj : resource.getContents()) {
                if (!clazz.isAssignableFrom(obj.getClass())) continue;
                return (T)obj;
            }
        }
        return null;
    }

    public static <T extends EObject, R extends EObject> T getModel(ResourceSet resourceSet, Class<T> clazz, EFactory factory, String fileExtension, Class<R> referenceClazz) {
        Resource resource;
        T existingModel = ResourceUtils.getModel(resourceSet, clazz);
        if (existingModel != null) {
            return existingModel;
        }
        if (fileExtension != null) {
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(fileExtension, new XMLResourceFactoryImpl());
        }
        URI uri = null;
        EObject obj = null;
        if (referenceClazz != null) {
            obj = (EObject)ResourceUtils.getModel(resourceSet, referenceClazz);
            if (obj != null) {
                uri = obj.eResource().getURI();
            }
        } else if (!resourceSet.getResources().isEmpty()) {
            resource = (Resource)resourceSet.getResources().get(0);
            uri = resource.getURI();
            obj = (EObject)resource.getContents().get(0);
        }
        if (factory != null && fileExtension != null && uri != null && obj != null) {
            uri = uri.trimFileExtension().appendFileExtension(fileExtension);
            resource = resourceSet.createResource(uri);
            final EObject newModel = factory.create(EcoreUtils.getEClassForClass(clazz));
            ITopLevelElement modelContext = IPersistencyService.getInstance().getTopLevelElementFor(obj);
            modelContext.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    resource.getContents().add((Object)newModel);
                }
            });
            return (T)newModel;
        }
        return null;
    }

    public static IFile getIFile(Resource resource) {
        URI uri = resource.getURI();
        String resourcePath = uri.toPlatformString(true);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource member = workspaceRoot.findMember(resourcePath);
        return (IFile)member;
    }

    public static Path getModelProjectPath(EObject model) {
        IFile modelFile = ResourceUtils.getIFile(model.eResource());
        return modelFile.getLocation().toFile().toPath();
    }

    public static String getModelFileName(EObject model) {
        IFile modelFile = ResourceUtils.getIFile(model.eResource());
        return modelFile.getName();
    }

    public static class KernelResourceFactory
    extends ResourceFactoryImpl {
        public Resource createResource(URI uri) {
            return new KernelXMIResource(uri);
        }

        private final class DanglingReferencesCleanupXMIHandler
        extends SAXXMIHandler {
            private DanglingReferencesCleanupXMIHandler(XMLResource xmiResource, XMLHelper helper, Map<?, ?> options) {
                super(xmiResource, helper, options);
            }

            protected void handleForwardReferences(boolean isEndDocument) {
                ArrayList<XMLHandler.SingleReference> toRemoveFwdSingleRefs = new ArrayList<XMLHandler.SingleReference>();
                for (XMLHandler.SingleReference ref : this.forwardSingleReferences) {
                    EObject obj;
                    try {
                        obj = this.xmlResource.getEObject((String)ref.getValue());
                    }
                    catch (RuntimeException exception) {
                        obj = null;
                    }
                    if (obj != null && !(obj instanceof AnyType)) continue;
                    this.warnRefWithUnknownType((AnyType)obj, ref.getLineNumber(), ref.getColumnNumber());
                    toRemoveFwdSingleRefs.add(ref);
                }
                this.forwardSingleReferences.removeAll(toRemoveFwdSingleRefs);
                ArrayList<XMLHandler.ManyReference> toRemoveFwdManyRefs = new ArrayList<XMLHandler.ManyReference>();
                block5: for (XMLHandler.ManyReference ref : this.forwardManyReferences) {
                    Object[] values;
                    Object[] objectArray = values = ref.getValues();
                    int n = values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        EObject obj;
                        Object id = objectArray[n2];
                        try {
                            obj = this.xmlResource.getEObject((String)id);
                        }
                        catch (RuntimeException exception) {
                            obj = null;
                        }
                        if (obj == null || obj instanceof AnyType) {
                            this.warnRefWithUnknownType((AnyType)obj, ref.getLineNumber(), ref.getColumnNumber());
                            toRemoveFwdManyRefs.add(ref);
                            continue block5;
                        }
                        ++n2;
                    }
                }
                this.forwardManyReferences.removeAll(toRemoveFwdManyRefs);
                super.handleForwardReferences(isEndDocument);
            }

            private void warnRefWithUnknownType(AnyType obj, int line, int col) {
                String message = "Removing reference to element with unknown type" + (String)(obj != null ? " \"" + obj.eClass().getName() + "\"" : "") + " in line " + line + ", column " + col + ".";
                LoggingUtils.warning(ToolingKernelActivator.getDefault(), message);
            }
        }

        private final class KernelXMIResource
        extends XMIResourceImpl {
            private KernelXMIResource(URI uri) {
                super(uri);
            }

            protected boolean useIDs() {
                return true;
            }

            public String getID(EObject eObject) {
                String id = super.getID(eObject);
                if (id == null && eObject instanceof IIdLabeled) {
                    id = String.valueOf(((IIdLabeled)eObject).getId());
                    this.setID(eObject, id);
                }
                return id;
            }

            public Map<EObject, String> getEObjectToIDMap() {
                if (this.eObjectToIDMap == null) {
                    this.eObjectToIDMap = new IdentityHashMap();
                }
                return this.eObjectToIDMap;
            }

            public Map<EObject, AnyType> getEObjectToExtensionMap() {
                if (this.eObjectToExtensionMap == null) {
                    this.eObjectToExtensionMap = new IdentityHashMap();
                }
                return this.eObjectToExtensionMap;
            }

            protected XMLLoad createXMLLoad() {
                return new XMILoadImpl(this.createXMLHelper()){

                    protected DefaultHandler makeDefaultHandler() {
                        return new DanglingReferencesCleanupXMIHandler(this.resource, this.helper, this.options);
                    }
                };
            }
        }
    }
}

