/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.extension.ITransformationProvider;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.data.TransformationProviderChain;
import org.fortiss.tooling.kernel.extension.exception.AllChainTransformationsFailedException;
import org.fortiss.tooling.kernel.extension.exception.ChainTransformationFailedException;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.service.ITransformationService;

public final class TransformationUtils {
    public static <T> T createTransformedObjectFor(EObject sourceElement, Class<T> targetClass, ITransformationContext context) throws ChainTransformationFailedException {
        List<TransformationProviderChain> chainList = ITransformationService.getInstance().getTransformationProviderChain(sourceElement.getClass(), targetClass, context);
        ArrayList<ChainTransformationFailedException> exceptionList = new ArrayList<ChainTransformationFailedException>();
        if (!chainList.isEmpty()) {
            for (TransformationProviderChain chain : chainList) {
                try {
                    Object executableObject = chain.transform(sourceElement, context);
                    Assert.isNotNull((Object)executableObject, (String)("The resulting object of the transformation of the object " + String.valueOf(sourceElement) + " to " + targetClass.getSimpleName() + "is null, but did not fail. Please ensure correct operation of all involved TransformationProviders."));
                    return (T)executableObject;
                }
                catch (ChainTransformationFailedException ctfe) {
                    exceptionList.add(ctfe);
                }
            }
        }
        if (exceptionList.isEmpty()) {
            throw new NoTransformationChainFound(sourceElement, targetClass);
        }
        throw new AllChainTransformationsFailedException(exceptionList);
    }

    public static <T> T createTransformedObjectWithoutExceptionFor(EObject sourceElement, Class<T> targetClass, ITransformationContext context) {
        try {
            return TransformationUtils.createTransformedObjectFor(sourceElement, targetClass, context);
        }
        catch (ChainTransformationFailedException ctfe) {
            return null;
        }
    }

    public static boolean canTransform(EObject sourceElement, Class<?> targetClass, ITransformationContext context) {
        return ITransformationService.getInstance().canTransform(sourceElement, targetClass, context);
    }

    public static Throwable getOriginalCause(Throwable e) {
        Throwable f = e.getCause();
        Throwable previous = e;
        while (f != null) {
            previous = f;
            f = f.getCause();
        }
        return previous;
    }

    public static class NoTransformationChainFound
    extends ChainTransformationFailedException {
        private EObject sourceElement;
        private Class<?> targetClass;

        public NoTransformationChainFound(EObject sourceElement, Class<?> targetClass) {
            super((TransformationProviderChain)null, (ITransformationProvider)null, (List<Object>)null, (TransformationFailedException)null);
            this.sourceElement = sourceElement;
            this.targetClass = targetClass;
        }

        @Override
        public String getMessage() {
            return "No transformation chain found from " + String.valueOf(this.sourceElement) + " to " + this.targetClass.getName();
        }

        public EObject getSourceElement() {
            return this.sourceElement;
        }

        public Class<?> getTargetClass() {
            return this.targetClass;
        }
    }
}

